/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.model.BatchParameters;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchParametersMarshaller {
    private static final MarshallingInfo<String> JOBDEFINITION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobDefinition").isBinary(false).build();
    private static final MarshallingInfo<String> JOBNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("JobName").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> ARRAYPROPERTIES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ArrayProperties").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RETRYSTRATEGY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("RetryStrategy").isBinary(false).build();
    private static final BatchParametersMarshaller INSTANCE = new BatchParametersMarshaller();

    private BatchParametersMarshaller() {
    }

    public static BatchParametersMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchParameters batchParameters, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchParameters, (String)"batchParameters");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchParameters.jobDefinition(), JOBDEFINITION_BINDING);
            protocolMarshaller.marshall((Object)batchParameters.jobName(), JOBNAME_BINDING);
            protocolMarshaller.marshall((Object)batchParameters.arrayProperties(), ARRAYPROPERTIES_BINDING);
            protocolMarshaller.marshall((Object)batchParameters.retryStrategy(), RETRYSTRATEGY_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

