/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudwatchevents.model.BatchArrayProperties;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class BatchArrayPropertiesMarshaller {
    private static final MarshallingInfo<Integer> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Size").isBinary(false).build();
    private static final BatchArrayPropertiesMarshaller INSTANCE = new BatchArrayPropertiesMarshaller();

    private BatchArrayPropertiesMarshaller() {
    }

    public static BatchArrayPropertiesMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(BatchArrayProperties batchArrayProperties, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)batchArrayProperties, (String)"batchArrayProperties");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)batchArrayProperties.size(), SIZE_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

