/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.model.BatchParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.EcsParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.InputTransformer;
import software.amazon.awssdk.services.cloudwatchevents.model.KinesisParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.RunCommandParameters;
import software.amazon.awssdk.services.cloudwatchevents.model.SqsParameters;
import software.amazon.awssdk.services.cloudwatchevents.transform.TargetMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Target
implements StructuredPojo,
ToCopyableBuilder<Builder, Target> {
    private final String id;
    private final String arn;
    private final String roleArn;
    private final String input;
    private final String inputPath;
    private final InputTransformer inputTransformer;
    private final KinesisParameters kinesisParameters;
    private final RunCommandParameters runCommandParameters;
    private final EcsParameters ecsParameters;
    private final BatchParameters batchParameters;
    private final SqsParameters sqsParameters;

    private Target(BuilderImpl builder) {
        this.id = builder.id;
        this.arn = builder.arn;
        this.roleArn = builder.roleArn;
        this.input = builder.input;
        this.inputPath = builder.inputPath;
        this.inputTransformer = builder.inputTransformer;
        this.kinesisParameters = builder.kinesisParameters;
        this.runCommandParameters = builder.runCommandParameters;
        this.ecsParameters = builder.ecsParameters;
        this.batchParameters = builder.batchParameters;
        this.sqsParameters = builder.sqsParameters;
    }

    public String id() {
        return this.id;
    }

    public String arn() {
        return this.arn;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public String input() {
        return this.input;
    }

    public String inputPath() {
        return this.inputPath;
    }

    public InputTransformer inputTransformer() {
        return this.inputTransformer;
    }

    public KinesisParameters kinesisParameters() {
        return this.kinesisParameters;
    }

    public RunCommandParameters runCommandParameters() {
        return this.runCommandParameters;
    }

    public EcsParameters ecsParameters() {
        return this.ecsParameters;
    }

    public BatchParameters batchParameters() {
        return this.batchParameters;
    }

    public SqsParameters sqsParameters() {
        return this.sqsParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.input());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputPath());
        hashCode = 31 * hashCode + Objects.hashCode(this.inputTransformer());
        hashCode = 31 * hashCode + Objects.hashCode(this.kinesisParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.runCommandParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.batchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.sqsParameters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Target)) {
            return false;
        }
        Target other = (Target)obj;
        return Objects.equals(this.id(), other.id()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.input(), other.input()) && Objects.equals(this.inputPath(), other.inputPath()) && Objects.equals(this.inputTransformer(), other.inputTransformer()) && Objects.equals(this.kinesisParameters(), other.kinesisParameters()) && Objects.equals(this.runCommandParameters(), other.runCommandParameters()) && Objects.equals(this.ecsParameters(), other.ecsParameters()) && Objects.equals(this.batchParameters(), other.batchParameters()) && Objects.equals(this.sqsParameters(), other.sqsParameters());
    }

    public String toString() {
        return ToString.builder((String)"Target").add("Id", (Object)this.id()).add("Arn", (Object)this.arn()).add("RoleArn", (Object)this.roleArn()).add("Input", (Object)this.input()).add("InputPath", (Object)this.inputPath()).add("InputTransformer", (Object)this.inputTransformer()).add("KinesisParameters", (Object)this.kinesisParameters()).add("RunCommandParameters", (Object)this.runCommandParameters()).add("EcsParameters", (Object)this.ecsParameters()).add("BatchParameters", (Object)this.batchParameters()).add("SqsParameters", (Object)this.sqsParameters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "Input": {
                return Optional.ofNullable(clazz.cast(this.input()));
            }
            case "InputPath": {
                return Optional.ofNullable(clazz.cast(this.inputPath()));
            }
            case "InputTransformer": {
                return Optional.ofNullable(clazz.cast(this.inputTransformer()));
            }
            case "KinesisParameters": {
                return Optional.ofNullable(clazz.cast(this.kinesisParameters()));
            }
            case "RunCommandParameters": {
                return Optional.ofNullable(clazz.cast(this.runCommandParameters()));
            }
            case "EcsParameters": {
                return Optional.ofNullable(clazz.cast(this.ecsParameters()));
            }
            case "BatchParameters": {
                return Optional.ofNullable(clazz.cast(this.batchParameters()));
            }
            case "SqsParameters": {
                return Optional.ofNullable(clazz.cast(this.sqsParameters()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TargetMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String id;
        private String arn;
        private String roleArn;
        private String input;
        private String inputPath;
        private InputTransformer inputTransformer;
        private KinesisParameters kinesisParameters;
        private RunCommandParameters runCommandParameters;
        private EcsParameters ecsParameters;
        private BatchParameters batchParameters;
        private SqsParameters sqsParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(Target model) {
            this.id(model.id);
            this.arn(model.arn);
            this.roleArn(model.roleArn);
            this.input(model.input);
            this.inputPath(model.inputPath);
            this.inputTransformer(model.inputTransformer);
            this.kinesisParameters(model.kinesisParameters);
            this.runCommandParameters(model.runCommandParameters);
            this.ecsParameters(model.ecsParameters);
            this.batchParameters(model.batchParameters);
            this.sqsParameters(model.sqsParameters);
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public final String getInput() {
            return this.input;
        }

        @Override
        public final Builder input(String input) {
            this.input = input;
            return this;
        }

        public final void setInput(String input) {
            this.input = input;
        }

        public final String getInputPath() {
            return this.inputPath;
        }

        @Override
        public final Builder inputPath(String inputPath) {
            this.inputPath = inputPath;
            return this;
        }

        public final void setInputPath(String inputPath) {
            this.inputPath = inputPath;
        }

        public final InputTransformer.Builder getInputTransformer() {
            return this.inputTransformer != null ? this.inputTransformer.toBuilder() : null;
        }

        @Override
        public final Builder inputTransformer(InputTransformer inputTransformer) {
            this.inputTransformer = inputTransformer;
            return this;
        }

        public final void setInputTransformer(InputTransformer.BuilderImpl inputTransformer) {
            this.inputTransformer = inputTransformer != null ? inputTransformer.build() : null;
        }

        public final KinesisParameters.Builder getKinesisParameters() {
            return this.kinesisParameters != null ? this.kinesisParameters.toBuilder() : null;
        }

        @Override
        public final Builder kinesisParameters(KinesisParameters kinesisParameters) {
            this.kinesisParameters = kinesisParameters;
            return this;
        }

        public final void setKinesisParameters(KinesisParameters.BuilderImpl kinesisParameters) {
            this.kinesisParameters = kinesisParameters != null ? kinesisParameters.build() : null;
        }

        public final RunCommandParameters.Builder getRunCommandParameters() {
            return this.runCommandParameters != null ? this.runCommandParameters.toBuilder() : null;
        }

        @Override
        public final Builder runCommandParameters(RunCommandParameters runCommandParameters) {
            this.runCommandParameters = runCommandParameters;
            return this;
        }

        public final void setRunCommandParameters(RunCommandParameters.BuilderImpl runCommandParameters) {
            this.runCommandParameters = runCommandParameters != null ? runCommandParameters.build() : null;
        }

        public final EcsParameters.Builder getEcsParameters() {
            return this.ecsParameters != null ? this.ecsParameters.toBuilder() : null;
        }

        @Override
        public final Builder ecsParameters(EcsParameters ecsParameters) {
            this.ecsParameters = ecsParameters;
            return this;
        }

        public final void setEcsParameters(EcsParameters.BuilderImpl ecsParameters) {
            this.ecsParameters = ecsParameters != null ? ecsParameters.build() : null;
        }

        public final BatchParameters.Builder getBatchParameters() {
            return this.batchParameters != null ? this.batchParameters.toBuilder() : null;
        }

        @Override
        public final Builder batchParameters(BatchParameters batchParameters) {
            this.batchParameters = batchParameters;
            return this;
        }

        public final void setBatchParameters(BatchParameters.BuilderImpl batchParameters) {
            this.batchParameters = batchParameters != null ? batchParameters.build() : null;
        }

        public final SqsParameters.Builder getSqsParameters() {
            return this.sqsParameters != null ? this.sqsParameters.toBuilder() : null;
        }

        @Override
        public final Builder sqsParameters(SqsParameters sqsParameters) {
            this.sqsParameters = sqsParameters;
            return this;
        }

        public final void setSqsParameters(SqsParameters.BuilderImpl sqsParameters) {
            this.sqsParameters = sqsParameters != null ? sqsParameters.build() : null;
        }

        public Target build() {
            return new Target(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Target> {
        public Builder id(String var1);

        public Builder arn(String var1);

        public Builder roleArn(String var1);

        public Builder input(String var1);

        public Builder inputPath(String var1);

        public Builder inputTransformer(InputTransformer var1);

        default public Builder inputTransformer(Consumer<InputTransformer.Builder> inputTransformer) {
            return this.inputTransformer((InputTransformer)((InputTransformer.Builder)InputTransformer.builder().applyMutation(inputTransformer)).build());
        }

        public Builder kinesisParameters(KinesisParameters var1);

        default public Builder kinesisParameters(Consumer<KinesisParameters.Builder> kinesisParameters) {
            return this.kinesisParameters((KinesisParameters)((KinesisParameters.Builder)KinesisParameters.builder().applyMutation(kinesisParameters)).build());
        }

        public Builder runCommandParameters(RunCommandParameters var1);

        default public Builder runCommandParameters(Consumer<RunCommandParameters.Builder> runCommandParameters) {
            return this.runCommandParameters((RunCommandParameters)((RunCommandParameters.Builder)RunCommandParameters.builder().applyMutation(runCommandParameters)).build());
        }

        public Builder ecsParameters(EcsParameters var1);

        default public Builder ecsParameters(Consumer<EcsParameters.Builder> ecsParameters) {
            return this.ecsParameters((EcsParameters)((EcsParameters.Builder)EcsParameters.builder().applyMutation(ecsParameters)).build());
        }

        public Builder batchParameters(BatchParameters var1);

        default public Builder batchParameters(Consumer<BatchParameters.Builder> batchParameters) {
            return this.batchParameters((BatchParameters)((BatchParameters.Builder)BatchParameters.builder().applyMutation(batchParameters)).build());
        }

        public Builder sqsParameters(SqsParameters var1);

        default public Builder sqsParameters(Consumer<SqsParameters.Builder> sqsParameters) {
            return this.sqsParameters((SqsParameters)((SqsParameters.Builder)SqsParameters.builder().applyMutation(sqsParameters)).build());
        }
    }
}

