/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.cloudwatchevents.model.RuleState;
import software.amazon.awssdk.services.cloudwatchevents.transform.RuleMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Rule
implements StructuredPojo,
ToCopyableBuilder<Builder, Rule> {
    private final String name;
    private final String arn;
    private final String eventPattern;
    private final String state;
    private final String description;
    private final String scheduleExpression;
    private final String roleArn;

    private Rule(BuilderImpl builder) {
        this.name = builder.name;
        this.arn = builder.arn;
        this.eventPattern = builder.eventPattern;
        this.state = builder.state;
        this.description = builder.description;
        this.scheduleExpression = builder.scheduleExpression;
        this.roleArn = builder.roleArn;
    }

    public String name() {
        return this.name;
    }

    public String arn() {
        return this.arn;
    }

    public String eventPattern() {
        return this.eventPattern;
    }

    public RuleState state() {
        return RuleState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public String description() {
        return this.description;
    }

    public String scheduleExpression() {
        return this.scheduleExpression;
    }

    public String roleArn() {
        return this.roleArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventPattern());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.scheduleExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rule)) {
            return false;
        }
        Rule other = (Rule)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.eventPattern(), other.eventPattern()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.scheduleExpression(), other.scheduleExpression()) && Objects.equals(this.roleArn(), other.roleArn());
    }

    public String toString() {
        return ToString.builder((String)"Rule").add("Name", (Object)this.name()).add("Arn", (Object)this.arn()).add("EventPattern", (Object)this.eventPattern()).add("State", (Object)this.stateAsString()).add("Description", (Object)this.description()).add("ScheduleExpression", (Object)this.scheduleExpression()).add("RoleArn", (Object)this.roleArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "EventPattern": {
                return Optional.ofNullable(clazz.cast(this.eventPattern()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "ScheduleExpression": {
                return Optional.ofNullable(clazz.cast(this.scheduleExpression()));
            }
            case "RoleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        RuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String arn;
        private String eventPattern;
        private String state;
        private String description;
        private String scheduleExpression;
        private String roleArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Rule model) {
            this.name(model.name);
            this.arn(model.arn);
            this.eventPattern(model.eventPattern);
            this.state(model.state);
            this.description(model.description);
            this.scheduleExpression(model.scheduleExpression);
            this.roleArn(model.roleArn);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getArn() {
            return this.arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getEventPattern() {
            return this.eventPattern;
        }

        @Override
        public final Builder eventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
            return this;
        }

        public final void setEventPattern(String eventPattern) {
            this.eventPattern = eventPattern;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(RuleState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getScheduleExpression() {
            return this.scheduleExpression;
        }

        @Override
        public final Builder scheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
            return this;
        }

        public final void setScheduleExpression(String scheduleExpression) {
            this.scheduleExpression = scheduleExpression;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        public Rule build() {
            return new Rule(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Rule> {
        public Builder name(String var1);

        public Builder arn(String var1);

        public Builder eventPattern(String var1);

        public Builder state(String var1);

        public Builder state(RuleState var1);

        public Builder description(String var1);

        public Builder scheduleExpression(String var1);

        public Builder roleArn(String var1);
    }
}

