/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.CloudWatchEventsResponse;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsResultEntry;
import software.amazon.awssdk.services.cloudwatchevents.model.PutTargetsResultEntryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutTargetsResponse
extends CloudWatchEventsResponse
implements ToCopyableBuilder<Builder, PutTargetsResponse> {
    private final Integer failedEntryCount;
    private final List<PutTargetsResultEntry> failedEntries;

    private PutTargetsResponse(BuilderImpl builder) {
        super(builder);
        this.failedEntryCount = builder.failedEntryCount;
        this.failedEntries = builder.failedEntries;
    }

    public Integer failedEntryCount() {
        return this.failedEntryCount;
    }

    public List<PutTargetsResultEntry> failedEntries() {
        return this.failedEntries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEntryCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.failedEntries());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutTargetsResponse)) {
            return false;
        }
        PutTargetsResponse other = (PutTargetsResponse)((Object)obj);
        return Objects.equals(this.failedEntryCount(), other.failedEntryCount()) && Objects.equals(this.failedEntries(), other.failedEntries());
    }

    public String toString() {
        return ToString.builder((String)"PutTargetsResponse").add("FailedEntryCount", (Object)this.failedEntryCount()).add("FailedEntries", this.failedEntries()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FailedEntryCount": {
                return Optional.ofNullable(clazz.cast(this.failedEntryCount()));
            }
            case "FailedEntries": {
                return Optional.ofNullable(clazz.cast(this.failedEntries()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchEventsResponse.BuilderImpl
    implements Builder {
        private Integer failedEntryCount;
        private List<PutTargetsResultEntry> failedEntries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutTargetsResponse model) {
            super(model);
            this.failedEntryCount(model.failedEntryCount);
            this.failedEntries(model.failedEntries);
        }

        public final Integer getFailedEntryCount() {
            return this.failedEntryCount;
        }

        @Override
        public final Builder failedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
            return this;
        }

        public final void setFailedEntryCount(Integer failedEntryCount) {
            this.failedEntryCount = failedEntryCount;
        }

        public final Collection<PutTargetsResultEntry.Builder> getFailedEntries() {
            return this.failedEntries != null ? (Collection)this.failedEntries.stream().map(PutTargetsResultEntry::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failedEntries(Collection<PutTargetsResultEntry> failedEntries) {
            this.failedEntries = PutTargetsResultEntryListCopier.copy(failedEntries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(PutTargetsResultEntry ... failedEntries) {
            this.failedEntries(Arrays.asList(failedEntries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failedEntries(Consumer<PutTargetsResultEntry.Builder> ... failedEntries) {
            this.failedEntries(Stream.of(failedEntries).map(c -> (PutTargetsResultEntry)((PutTargetsResultEntry.Builder)PutTargetsResultEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailedEntries(Collection<PutTargetsResultEntry.BuilderImpl> failedEntries) {
            this.failedEntries = PutTargetsResultEntryListCopier.copyFromBuilder(failedEntries);
        }

        @Override
        public PutTargetsResponse build() {
            return new PutTargetsResponse(this);
        }
    }

    public static interface Builder
    extends CloudWatchEventsResponse.Builder,
    CopyableBuilder<Builder, PutTargetsResponse> {
        public Builder failedEntryCount(Integer var1);

        public Builder failedEntries(Collection<PutTargetsResultEntry> var1);

        public Builder failedEntries(PutTargetsResultEntry ... var1);

        public Builder failedEntries(Consumer<PutTargetsResultEntry.Builder> ... var1);
    }
}

