/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatchevents.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatchevents.model.AssignPublicIp;
import software.amazon.awssdk.services.cloudwatchevents.model.StringListCopier;
import software.amazon.awssdk.services.cloudwatchevents.transform.AwsVpcConfigurationMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsVpcConfiguration
implements StructuredPojo,
ToCopyableBuilder<Builder, AwsVpcConfiguration> {
    private final List<String> subnets;
    private final List<String> securityGroups;
    private final String assignPublicIp;

    private AwsVpcConfiguration(BuilderImpl builder) {
        this.subnets = builder.subnets;
        this.securityGroups = builder.securityGroups;
        this.assignPublicIp = builder.assignPublicIp;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<String> securityGroups() {
        return this.securityGroups;
    }

    public AssignPublicIp assignPublicIp() {
        return AssignPublicIp.fromValue(this.assignPublicIp);
    }

    public String assignPublicIpAsString() {
        return this.assignPublicIp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.subnets());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityGroups());
        hashCode = 31 * hashCode + Objects.hashCode(this.assignPublicIpAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsVpcConfiguration)) {
            return false;
        }
        AwsVpcConfiguration other = (AwsVpcConfiguration)obj;
        return Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.assignPublicIpAsString(), other.assignPublicIpAsString());
    }

    public String toString() {
        return ToString.builder((String)"AwsVpcConfiguration").add("Subnets", this.subnets()).add("SecurityGroups", this.securityGroups()).add("AssignPublicIp", (Object)this.assignPublicIpAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "AssignPublicIp": {
                return Optional.ofNullable(clazz.cast(this.assignPublicIpAsString()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AwsVpcConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> subnets = DefaultSdkAutoConstructList.getInstance();
        private List<String> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String assignPublicIp;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsVpcConfiguration model) {
            this.subnets(model.subnets);
            this.securityGroups(model.securityGroups);
            this.assignPublicIp(model.assignPublicIp);
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        public final Collection<String> getSecurityGroups() {
            return this.securityGroups;
        }

        @Override
        public final Builder securityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(String ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        public final void setSecurityGroups(Collection<String> securityGroups) {
            this.securityGroups = StringListCopier.copy(securityGroups);
        }

        public final String getAssignPublicIp() {
            return this.assignPublicIp;
        }

        @Override
        public final Builder assignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
            return this;
        }

        @Override
        public final Builder assignPublicIp(AssignPublicIp assignPublicIp) {
            this.assignPublicIp(assignPublicIp.toString());
            return this;
        }

        public final void setAssignPublicIp(String assignPublicIp) {
            this.assignPublicIp = assignPublicIp;
        }

        public AwsVpcConfiguration build() {
            return new AwsVpcConfiguration(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AwsVpcConfiguration> {
        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroups(Collection<String> var1);

        public Builder securityGroups(String ... var1);

        public Builder assignPublicIp(String var1);

        public Builder assignPublicIp(AssignPublicIp var1);
    }
}

