/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.query.AwsQueryProtocolFactory;
import software.amazon.awssdk.services.cloudwatch.CloudWatchAsyncClient;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchException;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.ConcurrentModificationException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardInvalidInputErrorException;
import software.amazon.awssdk.services.cloudwatch.model.DashboardNotFoundErrorException;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamRequest;
import software.amazon.awssdk.services.cloudwatch.model.DeleteMetricStreamResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsForMetricResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAnomalyDetectorsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.DisableInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsResponse;
import software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.EnableInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetInsightRuleReportResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStatisticsResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricStreamResponse;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageRequest;
import software.amazon.awssdk.services.cloudwatch.model.GetMetricWidgetImageResponse;
import software.amazon.awssdk.services.cloudwatch.model.InternalServiceException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidFormatException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidNextTokenException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.cloudwatch.model.InvalidParameterValueException;
import software.amazon.awssdk.services.cloudwatch.model.LimitExceededException;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListDashboardsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListManagedInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricStreamsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.cloudwatch.model.MissingRequiredParameterException;
import software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutAnomalyDetectorResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutCompositeAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutDashboardResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutInsightRuleResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutManagedInsightRulesResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricAlarmResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricDataResponse;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamRequest;
import software.amazon.awssdk.services.cloudwatch.model.PutMetricStreamResponse;
import software.amazon.awssdk.services.cloudwatch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateRequest;
import software.amazon.awssdk.services.cloudwatch.model.SetAlarmStateResponse;
import software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsRequest;
import software.amazon.awssdk.services.cloudwatch.model.StartMetricStreamsResponse;
import software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsRequest;
import software.amazon.awssdk.services.cloudwatch.model.StopMetricStreamsResponse;
import software.amazon.awssdk.services.cloudwatch.model.TagResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.TagResourceResponse;
import software.amazon.awssdk.services.cloudwatch.model.UntagResourceRequest;
import software.amazon.awssdk.services.cloudwatch.model.UntagResourceResponse;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAlarmHistoryPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAlarmsPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeAnomalyDetectorsPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.DescribeInsightRulesPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.GetMetricDataPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.ListDashboardsPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.ListManagedInsightRulesPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.ListMetricStreamsPublisher;
import software.amazon.awssdk.services.cloudwatch.paginators.ListMetricsPublisher;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DeleteMetricStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmHistoryRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsForMetricRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAlarmsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeAnomalyDetectorsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DescribeInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.DisableInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableAlarmActionsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.EnableInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetInsightRuleReportRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStatisticsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.GetMetricWidgetImageRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListManagedInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListMetricsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutAnomalyDetectorRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutCompositeAlarmRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutDashboardRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutInsightRuleRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutManagedInsightRulesRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricAlarmRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricDataRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.PutMetricStreamRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.SetAlarmStateRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.StartMetricStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.StopMetricStreamsRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.cloudwatch.waiters.CloudWatchAsyncWaiter;
import software.amazon.awssdk.utils.CompletableFutureUtils;

@SdkInternalApi
final class DefaultCloudWatchAsyncClient
implements CloudWatchAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultCloudWatchAsyncClient.class);
    private final AsyncClientHandler clientHandler;
    private final AwsQueryProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;
    private final ScheduledExecutorService executorService;

    protected DefaultCloudWatchAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init();
        this.executorService = (ScheduledExecutorService)clientConfiguration.option((ClientOption)SdkClientOption.SCHEDULED_EXECUTOR_SERVICE);
    }

    public final String serviceName() {
        return "monitoring";
    }

    @Override
    public CompletableFuture<DeleteAlarmsResponse> deleteAlarms(DeleteAlarmsRequest deleteAlarmsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAlarmsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAlarms");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAlarmsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAlarms").withMarshaller((Marshaller)new DeleteAlarmsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAlarmsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$deleteAlarms$1(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$deleteAlarms$2((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteAnomalyDetectorResponse> deleteAnomalyDetector(DeleteAnomalyDetectorRequest deleteAnomalyDetectorRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteAnomalyDetector");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteAnomalyDetectorResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteAnomalyDetector").withMarshaller((Marshaller)new DeleteAnomalyDetectorRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteAnomalyDetectorRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$deleteAnomalyDetector$4(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$deleteAnomalyDetector$5((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteDashboardsResponse> deleteDashboards(DeleteDashboardsRequest deleteDashboardsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteDashboardsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteDashboards");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteDashboardsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteDashboards").withMarshaller((Marshaller)new DeleteDashboardsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteDashboardsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$deleteDashboards$7(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$deleteDashboards$8((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteInsightRulesResponse> deleteInsightRules(DeleteInsightRulesRequest deleteInsightRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteInsightRules");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteInsightRulesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteInsightRules").withMarshaller((Marshaller)new DeleteInsightRulesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteInsightRulesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$deleteInsightRules$10(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$deleteInsightRules$11((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DeleteMetricStreamResponse> deleteMetricStream(DeleteMetricStreamRequest deleteMetricStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, deleteMetricStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteMetricStream");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DeleteMetricStreamResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteMetricStream").withMarshaller((Marshaller)new DeleteMetricStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)deleteMetricStreamRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$deleteMetricStream$13(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$deleteMetricStream$14((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAlarmHistoryResponse> describeAlarmHistory(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeAlarmHistoryRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarmHistory");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAlarmHistoryResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarmHistory").withMarshaller((Marshaller)new DescribeAlarmHistoryRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAlarmHistoryRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$describeAlarmHistory$16(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$describeAlarmHistory$17((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeAlarmHistoryPublisher describeAlarmHistoryPaginator(DescribeAlarmHistoryRequest describeAlarmHistoryRequest) {
        return new DescribeAlarmHistoryPublisher(this, this.applyPaginatorUserAgent(describeAlarmHistoryRequest));
    }

    @Override
    public CompletableFuture<DescribeAlarmsResponse> describeAlarms(DescribeAlarmsRequest describeAlarmsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeAlarmsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarms");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAlarmsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarms").withMarshaller((Marshaller)new DescribeAlarmsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAlarmsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$describeAlarms$19(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$describeAlarms$20((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DescribeAlarmsForMetricResponse> describeAlarmsForMetric(DescribeAlarmsForMetricRequest describeAlarmsForMetricRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeAlarmsForMetricRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAlarmsForMetric");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAlarmsForMetricResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAlarmsForMetric").withMarshaller((Marshaller)new DescribeAlarmsForMetricRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAlarmsForMetricRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$describeAlarmsForMetric$22(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$describeAlarmsForMetric$23((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeAlarmsPublisher describeAlarmsPaginator(DescribeAlarmsRequest describeAlarmsRequest) {
        return new DescribeAlarmsPublisher(this, this.applyPaginatorUserAgent(describeAlarmsRequest));
    }

    @Override
    public CompletableFuture<DescribeAnomalyDetectorsResponse> describeAnomalyDetectors(DescribeAnomalyDetectorsRequest describeAnomalyDetectorsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeAnomalyDetectorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeAnomalyDetectors");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeAnomalyDetectorsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeAnomalyDetectors").withMarshaller((Marshaller)new DescribeAnomalyDetectorsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeAnomalyDetectorsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$describeAnomalyDetectors$25(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$describeAnomalyDetectors$26((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeAnomalyDetectorsPublisher describeAnomalyDetectorsPaginator(DescribeAnomalyDetectorsRequest describeAnomalyDetectorsRequest) {
        return new DescribeAnomalyDetectorsPublisher(this, this.applyPaginatorUserAgent(describeAnomalyDetectorsRequest));
    }

    @Override
    public CompletableFuture<DescribeInsightRulesResponse> describeInsightRules(DescribeInsightRulesRequest describeInsightRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, describeInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DescribeInsightRules");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DescribeInsightRulesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DescribeInsightRules").withMarshaller((Marshaller)new DescribeInsightRulesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)describeInsightRulesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$describeInsightRules$28(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$describeInsightRules$29((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public DescribeInsightRulesPublisher describeInsightRulesPaginator(DescribeInsightRulesRequest describeInsightRulesRequest) {
        return new DescribeInsightRulesPublisher(this, this.applyPaginatorUserAgent(describeInsightRulesRequest));
    }

    @Override
    public CompletableFuture<DisableAlarmActionsResponse> disableAlarmActions(DisableAlarmActionsRequest disableAlarmActionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableAlarmActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableAlarmActions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableAlarmActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableAlarmActions").withMarshaller((Marshaller)new DisableAlarmActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableAlarmActionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$disableAlarmActions$31(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$disableAlarmActions$32((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<DisableInsightRulesResponse> disableInsightRules(DisableInsightRulesRequest disableInsightRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, disableInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisableInsightRules");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(DisableInsightRulesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisableInsightRules").withMarshaller((Marshaller)new DisableInsightRulesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)disableInsightRulesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$disableInsightRules$34(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$disableInsightRules$35((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableAlarmActionsResponse> enableAlarmActions(EnableAlarmActionsRequest enableAlarmActionsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableAlarmActionsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableAlarmActions");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableAlarmActionsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableAlarmActions").withMarshaller((Marshaller)new EnableAlarmActionsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableAlarmActionsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$enableAlarmActions$37(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$enableAlarmActions$38((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<EnableInsightRulesResponse> enableInsightRules(EnableInsightRulesRequest enableInsightRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, enableInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"EnableInsightRules");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(EnableInsightRulesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("EnableInsightRules").withMarshaller((Marshaller)new EnableInsightRulesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)enableInsightRulesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$enableInsightRules$40(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$enableInsightRules$41((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetDashboardResponse> getDashboard(GetDashboardRequest getDashboardRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, getDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetDashboard");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetDashboardResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetDashboard").withMarshaller((Marshaller)new GetDashboardRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getDashboardRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$getDashboard$43(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$getDashboard$44((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetInsightRuleReportResponse> getInsightRuleReport(GetInsightRuleReportRequest getInsightRuleReportRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, getInsightRuleReportRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetInsightRuleReport");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetInsightRuleReportResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetInsightRuleReport").withMarshaller((Marshaller)new GetInsightRuleReportRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getInsightRuleReportRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$getInsightRuleReport$46(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$getInsightRuleReport$47((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMetricDataResponse> getMetricData(GetMetricDataRequest getMetricDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricData");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetMetricDataResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricData").withMarshaller((Marshaller)new GetMetricDataRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMetricDataRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$getMetricData$49(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$getMetricData$50((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public GetMetricDataPublisher getMetricDataPaginator(GetMetricDataRequest getMetricDataRequest) {
        return new GetMetricDataPublisher(this, this.applyPaginatorUserAgent(getMetricDataRequest));
    }

    @Override
    public CompletableFuture<GetMetricStatisticsResponse> getMetricStatistics(GetMetricStatisticsRequest getMetricStatisticsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMetricStatisticsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricStatistics");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetMetricStatisticsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricStatistics").withMarshaller((Marshaller)new GetMetricStatisticsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMetricStatisticsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$getMetricStatistics$52(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$getMetricStatistics$53((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMetricStreamResponse> getMetricStream(GetMetricStreamRequest getMetricStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMetricStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricStream");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetMetricStreamResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricStream").withMarshaller((Marshaller)new GetMetricStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMetricStreamRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$getMetricStream$55(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$getMetricStream$56((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<GetMetricWidgetImageResponse> getMetricWidgetImage(GetMetricWidgetImageRequest getMetricWidgetImageRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, getMetricWidgetImageRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetMetricWidgetImage");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(GetMetricWidgetImageResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetMetricWidgetImage").withMarshaller((Marshaller)new GetMetricWidgetImageRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)getMetricWidgetImageRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$getMetricWidgetImage$58(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$getMetricWidgetImage$59((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, listDashboardsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListDashboards");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListDashboardsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListDashboards").withMarshaller((Marshaller)new ListDashboardsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listDashboardsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$listDashboards$61(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$listDashboards$62((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListDashboardsPublisher listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest) {
        return new ListDashboardsPublisher(this, this.applyPaginatorUserAgent(listDashboardsRequest));
    }

    @Override
    public CompletableFuture<ListManagedInsightRulesResponse> listManagedInsightRules(ListManagedInsightRulesRequest listManagedInsightRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, listManagedInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListManagedInsightRules");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListManagedInsightRulesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListManagedInsightRules").withMarshaller((Marshaller)new ListManagedInsightRulesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listManagedInsightRulesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$listManagedInsightRules$64(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$listManagedInsightRules$65((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListManagedInsightRulesPublisher listManagedInsightRulesPaginator(ListManagedInsightRulesRequest listManagedInsightRulesRequest) {
        return new ListManagedInsightRulesPublisher(this, this.applyPaginatorUserAgent(listManagedInsightRulesRequest));
    }

    @Override
    public CompletableFuture<ListMetricStreamsResponse> listMetricStreams(ListMetricStreamsRequest listMetricStreamsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, listMetricStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMetricStreams");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListMetricStreamsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMetricStreams").withMarshaller((Marshaller)new ListMetricStreamsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMetricStreamsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$listMetricStreams$67(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$listMetricStreams$68((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListMetricStreamsPublisher listMetricStreamsPaginator(ListMetricStreamsRequest listMetricStreamsRequest) {
        return new ListMetricStreamsPublisher(this, this.applyPaginatorUserAgent(listMetricStreamsRequest));
    }

    @Override
    public CompletableFuture<ListMetricsResponse> listMetrics(ListMetricsRequest listMetricsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, listMetricsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListMetrics");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListMetricsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListMetrics").withMarshaller((Marshaller)new ListMetricsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listMetricsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$listMetrics$70(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$listMetrics$71((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public ListMetricsPublisher listMetricsPaginator(ListMetricsRequest listMetricsRequest) {
        return new ListMetricsPublisher(this, this.applyPaginatorUserAgent(listMetricsRequest));
    }

    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(ListTagsForResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)listTagsForResourceRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$listTagsForResource$73(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$listTagsForResource$74((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutAnomalyDetectorResponse> putAnomalyDetector(PutAnomalyDetectorRequest putAnomalyDetectorRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, putAnomalyDetectorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutAnomalyDetector");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutAnomalyDetectorResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutAnomalyDetector").withMarshaller((Marshaller)new PutAnomalyDetectorRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putAnomalyDetectorRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$putAnomalyDetector$76(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$putAnomalyDetector$77((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutCompositeAlarmResponse> putCompositeAlarm(PutCompositeAlarmRequest putCompositeAlarmRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, putCompositeAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutCompositeAlarm");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutCompositeAlarmResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutCompositeAlarm").withMarshaller((Marshaller)new PutCompositeAlarmRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putCompositeAlarmRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$putCompositeAlarm$79(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$putCompositeAlarm$80((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutDashboardResponse> putDashboard(PutDashboardRequest putDashboardRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, putDashboardRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutDashboard");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutDashboardResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutDashboard").withMarshaller((Marshaller)new PutDashboardRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putDashboardRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$putDashboard$82(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$putDashboard$83((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutInsightRuleResponse> putInsightRule(PutInsightRuleRequest putInsightRuleRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, putInsightRuleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutInsightRule");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutInsightRuleResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutInsightRule").withMarshaller((Marshaller)new PutInsightRuleRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putInsightRuleRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$putInsightRule$85(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$putInsightRule$86((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutManagedInsightRulesResponse> putManagedInsightRules(PutManagedInsightRulesRequest putManagedInsightRulesRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, putManagedInsightRulesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutManagedInsightRules");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutManagedInsightRulesResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutManagedInsightRules").withMarshaller((Marshaller)new PutManagedInsightRulesRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putManagedInsightRulesRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$putManagedInsightRules$88(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$putManagedInsightRules$89((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutMetricAlarmResponse> putMetricAlarm(PutMetricAlarmRequest putMetricAlarmRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, putMetricAlarmRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMetricAlarm");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutMetricAlarmResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricAlarm").withMarshaller((Marshaller)new PutMetricAlarmRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putMetricAlarmRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$putMetricAlarm$91(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$putMetricAlarm$92((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutMetricDataResponse> putMetricData(PutMetricDataRequest putMetricDataRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, putMetricDataRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMetricData");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutMetricDataResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricData").withMarshaller((Marshaller)new PutMetricDataRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putMetricDataRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$putMetricData$94(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$putMetricData$95((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<PutMetricStreamResponse> putMetricStream(PutMetricStreamRequest putMetricStreamRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, putMetricStreamRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMetricStream");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(PutMetricStreamResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMetricStream").withMarshaller((Marshaller)new PutMetricStreamRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)putMetricStreamRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$putMetricStream$97(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$putMetricStream$98((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<SetAlarmStateResponse> setAlarmState(SetAlarmStateRequest setAlarmStateRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, setAlarmStateRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"SetAlarmState");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(SetAlarmStateResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("SetAlarmState").withMarshaller((Marshaller)new SetAlarmStateRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)setAlarmStateRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$setAlarmState$100(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$setAlarmState$101((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StartMetricStreamsResponse> startMetricStreams(StartMetricStreamsRequest startMetricStreamsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, startMetricStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartMetricStreams");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StartMetricStreamsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartMetricStreams").withMarshaller((Marshaller)new StartMetricStreamsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)startMetricStreamsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$startMetricStreams$103(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$startMetricStreams$104((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<StopMetricStreamsResponse> stopMetricStreams(StopMetricStreamsRequest stopMetricStreamsRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, stopMetricStreamsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StopMetricStreams");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(StopMetricStreamsResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("StopMetricStreams").withMarshaller((Marshaller)new StopMetricStreamsRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)stopMetricStreamsRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$stopMetricStreams$106(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$stopMetricStreams$107((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(TagResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withMarshaller((Marshaller)new TagResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)tagResourceRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$tagResource$109(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$tagResource$110((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = DefaultCloudWatchAsyncClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"CloudWatch");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(UntagResourceResponse::builder);
            HttpResponseHandler errorResponseHandler = this.protocolFactory.createErrorResponseHandler();
            CompletableFuture executeFuture = this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withMarshaller((Marshaller)new UntagResourceRequestMarshaller(this.protocolFactory)).withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withMetricCollector((MetricCollector)apiCallMetricCollector).withInput((SdkRequest)untagResourceRequest));
            CompletionStage whenCompleteFuture = null;
            whenCompleteFuture = executeFuture.whenComplete((arg_0, arg_1) -> DefaultCloudWatchAsyncClient.lambda$untagResource$112(metricPublishers, (MetricCollector)apiCallMetricCollector, arg_0, arg_1));
            return CompletableFutureUtils.forwardExceptionTo((CompletableFuture)whenCompleteFuture, (CompletableFuture)executeFuture);
        }
        catch (Throwable t) {
            metricPublishers.forEach(arg_0 -> DefaultCloudWatchAsyncClient.lambda$untagResource$113((MetricCollector)apiCallMetricCollector, arg_0));
            return CompletableFutureUtils.failedFuture((Throwable)t);
        }
    }

    public void close() {
        this.clientHandler.close();
    }

    private AwsQueryProtocolFactory init() {
        return AwsQueryProtocolFactory.builder().registerModeledException(ExceptionMetadata.builder().errorCode("ConcurrentModificationException").exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(Integer.valueOf(429)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterValue").exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidFormat").exceptionBuilderSupplier(InvalidFormatException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("MissingParameter").exceptionBuilderSupplier(MissingRequiredParameterException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidNextToken").exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("LimitExceeded").exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterCombination").exceptionBuilderSupplier(InvalidParameterCombinationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFound").exceptionBuilderSupplier(DashboardNotFoundErrorException::builder).httpStatusCode(Integer.valueOf(404)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InvalidParameterInput").exceptionBuilderSupplier(DashboardInvalidInputErrorException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServiceError").exceptionBuilderSupplier(InternalServiceException::builder).httpStatusCode(Integer.valueOf(500)).build()).clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(CloudWatchException::builder).build();
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends CloudWatchRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.17.265").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((CloudWatchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    @Override
    public CloudWatchAsyncWaiter waiter() {
        return CloudWatchAsyncWaiter.builder().client(this).scheduledExecutorService(this.executorService).build();
    }

    private static /* synthetic */ void lambda$untagResource$113(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$112(List metricPublishers, MetricCollector apiCallMetricCollector, UntagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$tagResource$110(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$109(List metricPublishers, MetricCollector apiCallMetricCollector, TagResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$stopMetricStreams$107(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$stopMetricStreams$106(List metricPublishers, MetricCollector apiCallMetricCollector, StopMetricStreamsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$startMetricStreams$104(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startMetricStreams$103(List metricPublishers, MetricCollector apiCallMetricCollector, StartMetricStreamsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$setAlarmState$101(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$setAlarmState$100(List metricPublishers, MetricCollector apiCallMetricCollector, SetAlarmStateResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putMetricStream$98(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMetricStream$97(List metricPublishers, MetricCollector apiCallMetricCollector, PutMetricStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putMetricData$95(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMetricData$94(List metricPublishers, MetricCollector apiCallMetricCollector, PutMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putMetricAlarm$92(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMetricAlarm$91(List metricPublishers, MetricCollector apiCallMetricCollector, PutMetricAlarmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putManagedInsightRules$89(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putManagedInsightRules$88(List metricPublishers, MetricCollector apiCallMetricCollector, PutManagedInsightRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putInsightRule$86(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putInsightRule$85(List metricPublishers, MetricCollector apiCallMetricCollector, PutInsightRuleResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putDashboard$83(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putDashboard$82(List metricPublishers, MetricCollector apiCallMetricCollector, PutDashboardResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putCompositeAlarm$80(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putCompositeAlarm$79(List metricPublishers, MetricCollector apiCallMetricCollector, PutCompositeAlarmResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$putAnomalyDetector$77(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putAnomalyDetector$76(List metricPublishers, MetricCollector apiCallMetricCollector, PutAnomalyDetectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listTagsForResource$74(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$73(List metricPublishers, MetricCollector apiCallMetricCollector, ListTagsForResourceResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMetrics$71(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMetrics$70(List metricPublishers, MetricCollector apiCallMetricCollector, ListMetricsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listMetricStreams$68(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listMetricStreams$67(List metricPublishers, MetricCollector apiCallMetricCollector, ListMetricStreamsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listManagedInsightRules$65(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listManagedInsightRules$64(List metricPublishers, MetricCollector apiCallMetricCollector, ListManagedInsightRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$listDashboards$62(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listDashboards$61(List metricPublishers, MetricCollector apiCallMetricCollector, ListDashboardsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMetricWidgetImage$59(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricWidgetImage$58(List metricPublishers, MetricCollector apiCallMetricCollector, GetMetricWidgetImageResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMetricStream$56(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricStream$55(List metricPublishers, MetricCollector apiCallMetricCollector, GetMetricStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMetricStatistics$53(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricStatistics$52(List metricPublishers, MetricCollector apiCallMetricCollector, GetMetricStatisticsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getMetricData$50(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getMetricData$49(List metricPublishers, MetricCollector apiCallMetricCollector, GetMetricDataResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getInsightRuleReport$47(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getInsightRuleReport$46(List metricPublishers, MetricCollector apiCallMetricCollector, GetInsightRuleReportResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$getDashboard$44(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getDashboard$43(List metricPublishers, MetricCollector apiCallMetricCollector, GetDashboardResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableInsightRules$41(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableInsightRules$40(List metricPublishers, MetricCollector apiCallMetricCollector, EnableInsightRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$enableAlarmActions$38(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$enableAlarmActions$37(List metricPublishers, MetricCollector apiCallMetricCollector, EnableAlarmActionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableInsightRules$35(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableInsightRules$34(List metricPublishers, MetricCollector apiCallMetricCollector, DisableInsightRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$disableAlarmActions$32(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disableAlarmActions$31(List metricPublishers, MetricCollector apiCallMetricCollector, DisableAlarmActionsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeInsightRules$29(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeInsightRules$28(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeInsightRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAnomalyDetectors$26(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAnomalyDetectors$25(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAnomalyDetectorsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAlarmsForMetric$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarmsForMetric$22(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAlarmsForMetricResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAlarms$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarms$19(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAlarmsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$describeAlarmHistory$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$describeAlarmHistory$16(List metricPublishers, MetricCollector apiCallMetricCollector, DescribeAlarmHistoryResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteMetricStream$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteMetricStream$13(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteMetricStreamResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteInsightRules$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteInsightRules$10(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteInsightRulesResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteDashboards$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteDashboards$7(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteDashboardsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAnomalyDetector$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAnomalyDetector$4(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAnomalyDetectorResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }

    private static /* synthetic */ void lambda$deleteAlarms$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteAlarms$1(List metricPublishers, MetricCollector apiCallMetricCollector, DeleteAlarmsResponse r, Throwable e) {
        metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
    }
}

