/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchResponse;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntriesCopier;
import software.amazon.awssdk.services.cloudwatch.model.MetricStreamEntry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListMetricStreamsResponse
extends CloudWatchResponse
implements ToCopyableBuilder<Builder, ListMetricStreamsResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListMetricStreamsResponse.getter(ListMetricStreamsResponse::nextToken)).setter(ListMetricStreamsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<MetricStreamEntry>> ENTRIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Entries").getter(ListMetricStreamsResponse.getter(ListMetricStreamsResponse::entries)).setter(ListMetricStreamsResponse.setter(Builder::entries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Entries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MetricStreamEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, ENTRIES_FIELD));
    private final String nextToken;
    private final List<MetricStreamEntry> entries;

    private ListMetricStreamsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.entries = builder.entries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasEntries() {
        return this.entries != null && !(this.entries instanceof SdkAutoConstructList);
    }

    public final List<MetricStreamEntry> entries() {
        return this.entries;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntries() ? this.entries() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMetricStreamsResponse)) {
            return false;
        }
        ListMetricStreamsResponse other = (ListMetricStreamsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasEntries() == other.hasEntries() && Objects.equals(this.entries(), other.entries());
    }

    public final String toString() {
        return ToString.builder((String)"ListMetricStreamsResponse").add("NextToken", (Object)this.nextToken()).add("Entries", this.hasEntries() ? this.entries() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "Entries": {
                return Optional.ofNullable(clazz.cast(this.entries()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMetricStreamsResponse, T> g) {
        return obj -> g.apply((ListMetricStreamsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudWatchResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<MetricStreamEntry> entries = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListMetricStreamsResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.entries(model.entries);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<MetricStreamEntry.Builder> getEntries() {
            List<MetricStreamEntry.Builder> result = MetricStreamEntriesCopier.copyToBuilder(this.entries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntries(Collection<MetricStreamEntry.BuilderImpl> entries) {
            this.entries = MetricStreamEntriesCopier.copyFromBuilder(entries);
        }

        @Override
        @Transient
        public final Builder entries(Collection<MetricStreamEntry> entries) {
            this.entries = MetricStreamEntriesCopier.copy(entries);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(MetricStreamEntry ... entries) {
            this.entries(Arrays.asList(entries));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder entries(Consumer<MetricStreamEntry.Builder> ... entries) {
            this.entries(Stream.of(entries).map(c -> (MetricStreamEntry)((MetricStreamEntry.Builder)MetricStreamEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListMetricStreamsResponse build() {
            return new ListMetricStreamsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudWatchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListMetricStreamsResponse> {
        public Builder nextToken(String var1);

        public Builder entries(Collection<MetricStreamEntry> var1);

        public Builder entries(MetricStreamEntry ... var1);

        public Builder entries(Consumer<MetricStreamEntry.Builder> ... var1);
    }
}

