/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DashboardEntry
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DashboardEntry> {
    private static final SdkField<String> DASHBOARD_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardName").getter(DashboardEntry.getter(DashboardEntry::dashboardName)).setter(DashboardEntry.setter(Builder::dashboardName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardName").build()}).build();
    private static final SdkField<String> DASHBOARD_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DashboardArn").getter(DashboardEntry.getter(DashboardEntry::dashboardArn)).setter(DashboardEntry.setter(Builder::dashboardArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardArn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModified").getter(DashboardEntry.getter(DashboardEntry::lastModified)).setter(DashboardEntry.setter(Builder::lastModified)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModified").build()}).build();
    private static final SdkField<Long> SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Size").getter(DashboardEntry.getter(DashboardEntry::size)).setter(DashboardEntry.setter(Builder::size)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Size").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_NAME_FIELD, DASHBOARD_ARN_FIELD, LAST_MODIFIED_FIELD, SIZE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String dashboardName;
    private final String dashboardArn;
    private final Instant lastModified;
    private final Long size;

    private DashboardEntry(BuilderImpl builder) {
        this.dashboardName = builder.dashboardName;
        this.dashboardArn = builder.dashboardArn;
        this.lastModified = builder.lastModified;
        this.size = builder.size;
    }

    public final String dashboardName() {
        return this.dashboardName;
    }

    public final String dashboardArn() {
        return this.dashboardArn;
    }

    public final Instant lastModified() {
        return this.lastModified;
    }

    public final Long size() {
        return this.size;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dashboardArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModified());
        hashCode = 31 * hashCode + Objects.hashCode(this.size());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardEntry)) {
            return false;
        }
        DashboardEntry other = (DashboardEntry)obj;
        return Objects.equals(this.dashboardName(), other.dashboardName()) && Objects.equals(this.dashboardArn(), other.dashboardArn()) && Objects.equals(this.lastModified(), other.lastModified()) && Objects.equals(this.size(), other.size());
    }

    public final String toString() {
        return ToString.builder((String)"DashboardEntry").add("DashboardName", (Object)this.dashboardName()).add("DashboardArn", (Object)this.dashboardArn()).add("LastModified", (Object)this.lastModified()).add("Size", (Object)this.size()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DashboardName": {
                return Optional.ofNullable(clazz.cast(this.dashboardName()));
            }
            case "DashboardArn": {
                return Optional.ofNullable(clazz.cast(this.dashboardArn()));
            }
            case "LastModified": {
                return Optional.ofNullable(clazz.cast(this.lastModified()));
            }
            case "Size": {
                return Optional.ofNullable(clazz.cast(this.size()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardEntry, T> g) {
        return obj -> g.apply((DashboardEntry)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dashboardName;
        private String dashboardArn;
        private Instant lastModified;
        private Long size;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardEntry model) {
            this.dashboardName(model.dashboardName);
            this.dashboardArn(model.dashboardArn);
            this.lastModified(model.lastModified);
            this.size(model.size);
        }

        public final String getDashboardName() {
            return this.dashboardName;
        }

        @Override
        public final Builder dashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
            return this;
        }

        public final void setDashboardName(String dashboardName) {
            this.dashboardName = dashboardName;
        }

        public final String getDashboardArn() {
            return this.dashboardArn;
        }

        @Override
        public final Builder dashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
            return this;
        }

        public final void setDashboardArn(String dashboardArn) {
            this.dashboardArn = dashboardArn;
        }

        public final Instant getLastModified() {
            return this.lastModified;
        }

        @Override
        public final Builder lastModified(Instant lastModified) {
            this.lastModified = lastModified;
            return this;
        }

        public final void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public final Long getSize() {
            return this.size;
        }

        @Override
        public final Builder size(Long size) {
            this.size = size;
            return this;
        }

        public final void setSize(Long size) {
            this.size = size;
        }

        public DashboardEntry build() {
            return new DashboardEntry(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DashboardEntry> {
        public Builder dashboardName(String var1);

        public Builder dashboardArn(String var1);

        public Builder lastModified(Instant var1);

        public Builder size(Long var1);
    }
}

