/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapoint;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorDatapointsCopier;
import software.amazon.awssdk.services.cloudwatch.model.InsightRuleContributorKeysCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InsightRuleContributor
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InsightRuleContributor> {
    private static final SdkField<List<String>> KEYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Keys").getter(InsightRuleContributor.getter(InsightRuleContributor::keys)).setter(InsightRuleContributor.setter(Builder::keys)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Keys").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> APPROXIMATE_AGGREGATE_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("ApproximateAggregateValue").getter(InsightRuleContributor.getter(InsightRuleContributor::approximateAggregateValue)).setter(InsightRuleContributor.setter(Builder::approximateAggregateValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApproximateAggregateValue").build()}).build();
    private static final SdkField<List<InsightRuleContributorDatapoint>> DATAPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Datapoints").getter(InsightRuleContributor.getter(InsightRuleContributor::datapoints)).setter(InsightRuleContributor.setter(Builder::datapoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Datapoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InsightRuleContributorDatapoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KEYS_FIELD, APPROXIMATE_AGGREGATE_VALUE_FIELD, DATAPOINTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> keys;
    private final Double approximateAggregateValue;
    private final List<InsightRuleContributorDatapoint> datapoints;

    private InsightRuleContributor(BuilderImpl builder) {
        this.keys = builder.keys;
        this.approximateAggregateValue = builder.approximateAggregateValue;
        this.datapoints = builder.datapoints;
    }

    public boolean hasKeys() {
        return this.keys != null && !(this.keys instanceof SdkAutoConstructList);
    }

    public List<String> keys() {
        return this.keys;
    }

    public Double approximateAggregateValue() {
        return this.approximateAggregateValue;
    }

    public boolean hasDatapoints() {
        return this.datapoints != null && !(this.datapoints instanceof SdkAutoConstructList);
    }

    public List<InsightRuleContributorDatapoint> datapoints() {
        return this.datapoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasKeys() ? this.keys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.approximateAggregateValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDatapoints() ? this.datapoints() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InsightRuleContributor)) {
            return false;
        }
        InsightRuleContributor other = (InsightRuleContributor)obj;
        return this.hasKeys() == other.hasKeys() && Objects.equals(this.keys(), other.keys()) && Objects.equals(this.approximateAggregateValue(), other.approximateAggregateValue()) && this.hasDatapoints() == other.hasDatapoints() && Objects.equals(this.datapoints(), other.datapoints());
    }

    public String toString() {
        return ToString.builder((String)"InsightRuleContributor").add("Keys", this.hasKeys() ? this.keys() : null).add("ApproximateAggregateValue", (Object)this.approximateAggregateValue()).add("Datapoints", this.hasDatapoints() ? this.datapoints() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Keys": {
                return Optional.ofNullable(clazz.cast(this.keys()));
            }
            case "ApproximateAggregateValue": {
                return Optional.ofNullable(clazz.cast(this.approximateAggregateValue()));
            }
            case "Datapoints": {
                return Optional.ofNullable(clazz.cast(this.datapoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InsightRuleContributor, T> g) {
        return obj -> g.apply((InsightRuleContributor)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> keys = DefaultSdkAutoConstructList.getInstance();
        private Double approximateAggregateValue;
        private List<InsightRuleContributorDatapoint> datapoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(InsightRuleContributor model) {
            this.keys(model.keys);
            this.approximateAggregateValue(model.approximateAggregateValue);
            this.datapoints(model.datapoints);
        }

        public final Collection<String> getKeys() {
            if (this.keys instanceof SdkAutoConstructList) {
                return null;
            }
            return this.keys;
        }

        @Override
        public final Builder keys(Collection<String> keys) {
            this.keys = InsightRuleContributorKeysCopier.copy(keys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder keys(String ... keys) {
            this.keys(Arrays.asList(keys));
            return this;
        }

        public final void setKeys(Collection<String> keys) {
            this.keys = InsightRuleContributorKeysCopier.copy(keys);
        }

        public final Double getApproximateAggregateValue() {
            return this.approximateAggregateValue;
        }

        @Override
        public final Builder approximateAggregateValue(Double approximateAggregateValue) {
            this.approximateAggregateValue = approximateAggregateValue;
            return this;
        }

        public final void setApproximateAggregateValue(Double approximateAggregateValue) {
            this.approximateAggregateValue = approximateAggregateValue;
        }

        public final Collection<InsightRuleContributorDatapoint.Builder> getDatapoints() {
            if (this.datapoints instanceof SdkAutoConstructList) {
                return null;
            }
            return this.datapoints != null ? (Collection)this.datapoints.stream().map(InsightRuleContributorDatapoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder datapoints(Collection<InsightRuleContributorDatapoint> datapoints) {
            this.datapoints = InsightRuleContributorDatapointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(InsightRuleContributorDatapoint ... datapoints) {
            this.datapoints(Arrays.asList(datapoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Consumer<InsightRuleContributorDatapoint.Builder> ... datapoints) {
            this.datapoints(Stream.of(datapoints).map(c -> (InsightRuleContributorDatapoint)((InsightRuleContributorDatapoint.Builder)InsightRuleContributorDatapoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setDatapoints(Collection<InsightRuleContributorDatapoint.BuilderImpl> datapoints) {
            this.datapoints = InsightRuleContributorDatapointsCopier.copyFromBuilder(datapoints);
        }

        public InsightRuleContributor build() {
            return new InsightRuleContributor(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InsightRuleContributor> {
        public Builder keys(Collection<String> var1);

        public Builder keys(String ... var1);

        public Builder approximateAggregateValue(Double var1);

        public Builder datapoints(Collection<InsightRuleContributorDatapoint> var1);

        public Builder datapoints(InsightRuleContributorDatapoint ... var1);

        public Builder datapoints(Consumer<InsightRuleContributorDatapoint.Builder> ... var1);
    }
}

