/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.StringConversion;
import software.amazon.awssdk.services.cloudwatch.model.DeleteAlarmsRequest;

public class DeleteAlarmsRequestMarshaller
implements Marshaller<Request<DeleteAlarmsRequest>, DeleteAlarmsRequest> {
    public Request<DeleteAlarmsRequest> marshall(DeleteAlarmsRequest deleteAlarmsRequest) {
        if (deleteAlarmsRequest == null) {
            throw SdkClientException.builder().message("Invalid argument passed to marshall(...)").build();
        }
        DefaultRequest request = new DefaultRequest((Object)deleteAlarmsRequest, "CloudWatchClient");
        request.addParameter("Action", "DeleteAlarms");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (deleteAlarmsRequest.alarmNames().isEmpty() && !(deleteAlarmsRequest.alarmNames() instanceof SdkAutoConstructList)) {
            request.addParameter("AlarmNames", "");
        } else if (!deleteAlarmsRequest.alarmNames().isEmpty() && !(deleteAlarmsRequest.alarmNames() instanceof SdkAutoConstructList)) {
            List<String> alarmNamesList = deleteAlarmsRequest.alarmNames();
            int alarmNamesListIndex = 1;
            for (String alarmNamesListValue : alarmNamesList) {
                if (alarmNamesListValue != null) {
                    request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringConversion.fromString((String)alarmNamesListValue));
                }
                ++alarmNamesListIndex;
            }
        }
        return request;
    }
}

