/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsResponse;
import software.amazon.awssdk.services.cloudwatch.model.Metric;

public final class ListMetricsPaginator
implements SdkIterable<ListMetricsResponse> {
    private final CloudWatchClient client;
    private final ListMetricsRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public ListMetricsPaginator(CloudWatchClient client, ListMetricsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListMetricsResponseFetcher();
    }

    public Iterator<ListMetricsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Metric> metrics() {
        Function<ListMetricsResponse, Iterator> getIterator = response -> response != null ? response.metrics().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class ListMetricsResponseFetcher
    implements NextPageFetcher<ListMetricsResponse> {
        private ListMetricsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetricsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListMetricsResponse nextPage(ListMetricsResponse previousPage) {
            if (previousPage == null) {
                return ListMetricsPaginator.this.client.listMetrics(ListMetricsPaginator.this.firstRequest);
            }
            return ListMetricsPaginator.this.client.listMetrics((ListMetricsRequest)((Object)ListMetricsPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

