/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.cloudwatch.CloudWatchClient;
import software.amazon.awssdk.services.cloudwatch.model.AlarmHistoryItem;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryRequest;
import software.amazon.awssdk.services.cloudwatch.model.DescribeAlarmHistoryResponse;

public final class DescribeAlarmHistoryPaginator
implements SdkIterable<DescribeAlarmHistoryResponse> {
    private final CloudWatchClient client;
    private final DescribeAlarmHistoryRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeAlarmHistoryPaginator(CloudWatchClient client, DescribeAlarmHistoryRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeAlarmHistoryResponseFetcher();
    }

    public Iterator<DescribeAlarmHistoryResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<AlarmHistoryItem> alarmHistoryItems() {
        Function<DescribeAlarmHistoryResponse, Iterator> getIterator = response -> response != null ? response.alarmHistoryItems().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeAlarmHistoryResponseFetcher
    implements NextPageFetcher<DescribeAlarmHistoryResponse> {
        private DescribeAlarmHistoryResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAlarmHistoryResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeAlarmHistoryResponse nextPage(DescribeAlarmHistoryResponse previousPage) {
            if (previousPage == null) {
                return DescribeAlarmHistoryPaginator.this.client.describeAlarmHistory(DescribeAlarmHistoryPaginator.this.firstRequest);
            }
            return DescribeAlarmHistoryPaginator.this.client.describeAlarmHistory((DescribeAlarmHistoryRequest)((Object)DescribeAlarmHistoryPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

