/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.cloudwatch.model.CloudWatchRequest;
import software.amazon.awssdk.services.cloudwatch.model.HistoryItemType;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeAlarmHistoryRequest
extends CloudWatchRequest
implements ToCopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
    private final String alarmName;
    private final String historyItemType;
    private final Instant startDate;
    private final Instant endDate;
    private final Integer maxRecords;
    private final String nextToken;

    private DescribeAlarmHistoryRequest(BuilderImpl builder) {
        super(builder);
        this.alarmName = builder.alarmName;
        this.historyItemType = builder.historyItemType;
        this.startDate = builder.startDate;
        this.endDate = builder.endDate;
        this.maxRecords = builder.maxRecords;
        this.nextToken = builder.nextToken;
    }

    public String alarmName() {
        return this.alarmName;
    }

    public HistoryItemType historyItemType() {
        return HistoryItemType.fromValue(this.historyItemType);
    }

    public String historyItemTypeString() {
        return this.historyItemType;
    }

    public Instant startDate() {
        return this.startDate;
    }

    public Instant endDate() {
        return this.endDate;
    }

    public Integer maxRecords() {
        return this.maxRecords;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmName());
        hashCode = 31 * hashCode + Objects.hashCode(this.historyItemTypeString());
        hashCode = 31 * hashCode + Objects.hashCode(this.startDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.endDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRecords());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAlarmHistoryRequest)) {
            return false;
        }
        DescribeAlarmHistoryRequest other = (DescribeAlarmHistoryRequest)((Object)obj);
        return Objects.equals(this.alarmName(), other.alarmName()) && Objects.equals(this.historyItemTypeString(), other.historyItemTypeString()) && Objects.equals(this.startDate(), other.startDate()) && Objects.equals(this.endDate(), other.endDate()) && Objects.equals(this.maxRecords(), other.maxRecords()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.alarmName() != null) {
            sb.append("AlarmName: ").append(this.alarmName()).append(",");
        }
        if (this.historyItemTypeString() != null) {
            sb.append("HistoryItemType: ").append(this.historyItemTypeString()).append(",");
        }
        if (this.startDate() != null) {
            sb.append("StartDate: ").append(this.startDate()).append(",");
        }
        if (this.endDate() != null) {
            sb.append("EndDate: ").append(this.endDate()).append(",");
        }
        if (this.maxRecords() != null) {
            sb.append("MaxRecords: ").append(this.maxRecords()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AlarmName": {
                return Optional.of(clazz.cast(this.alarmName()));
            }
            case "HistoryItemType": {
                return Optional.of(clazz.cast(this.historyItemTypeString()));
            }
            case "StartDate": {
                return Optional.of(clazz.cast(this.startDate()));
            }
            case "EndDate": {
                return Optional.of(clazz.cast(this.endDate()));
            }
            case "MaxRecords": {
                return Optional.of(clazz.cast(this.maxRecords()));
            }
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends CloudWatchRequest.BuilderImpl
    implements Builder {
        private String alarmName;
        private String historyItemType;
        private Instant startDate;
        private Instant endDate;
        private Integer maxRecords;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAlarmHistoryRequest model) {
            this.alarmName(model.alarmName);
            this.historyItemType(model.historyItemType);
            this.startDate(model.startDate);
            this.endDate(model.endDate);
            this.maxRecords(model.maxRecords);
            this.nextToken(model.nextToken);
        }

        public final String getAlarmName() {
            return this.alarmName;
        }

        @Override
        public final Builder alarmName(String alarmName) {
            this.alarmName = alarmName;
            return this;
        }

        public final void setAlarmName(String alarmName) {
            this.alarmName = alarmName;
        }

        public final String getHistoryItemType() {
            return this.historyItemType;
        }

        @Override
        public final Builder historyItemType(String historyItemType) {
            this.historyItemType = historyItemType;
            return this;
        }

        @Override
        public final Builder historyItemType(HistoryItemType historyItemType) {
            this.historyItemType(historyItemType.toString());
            return this;
        }

        public final void setHistoryItemType(String historyItemType) {
            this.historyItemType = historyItemType;
        }

        public final Instant getStartDate() {
            return this.startDate;
        }

        @Override
        public final Builder startDate(Instant startDate) {
            this.startDate = startDate;
            return this;
        }

        public final void setStartDate(Instant startDate) {
            this.startDate = startDate;
        }

        public final Instant getEndDate() {
            return this.endDate;
        }

        @Override
        public final Builder endDate(Instant endDate) {
            this.endDate = endDate;
            return this;
        }

        public final void setEndDate(Instant endDate) {
            this.endDate = endDate;
        }

        public final Integer getMaxRecords() {
            return this.maxRecords;
        }

        @Override
        public final Builder maxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
            return this;
        }

        public final void setMaxRecords(Integer maxRecords) {
            this.maxRecords = maxRecords;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeAlarmHistoryRequest build() {
            return new DescribeAlarmHistoryRequest(this);
        }
    }

    public static interface Builder
    extends CloudWatchRequest.Builder,
    CopyableBuilder<Builder, DescribeAlarmHistoryRequest> {
        public Builder alarmName(String var1);

        public Builder historyItemType(String var1);

        public Builder historyItemType(HistoryItemType var1);

        public Builder startDate(Instant var1);

        public Builder endDate(Instant var1);

        public Builder maxRecords(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

