/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.DimensionFilter;
import software.amazon.awssdk.services.cloudwatch.model.ListMetricsRequest;

public class ListMetricsRequestMarshaller
implements Marshaller<Request<ListMetricsRequest>, ListMetricsRequest> {
    public Request<ListMetricsRequest> marshall(ListMetricsRequest listMetricsRequest) {
        List<DimensionFilter> dimensionsList;
        if (listMetricsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listMetricsRequest, "CloudWatchClient");
        request.addParameter("Action", "ListMetrics");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (listMetricsRequest.namespace() != null) {
            request.addParameter("Namespace", StringUtils.fromString((String)listMetricsRequest.namespace()));
        }
        if (listMetricsRequest.metricName() != null) {
            request.addParameter("MetricName", StringUtils.fromString((String)listMetricsRequest.metricName()));
        }
        if ((dimensionsList = listMetricsRequest.dimensions()) != null) {
            if (!dimensionsList.isEmpty()) {
                int dimensionsListIndex = 1;
                for (DimensionFilter dimensionsListValue : dimensionsList) {
                    if (dimensionsListValue.name() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Name", StringUtils.fromString((String)dimensionsListValue.name()));
                    }
                    if (dimensionsListValue.value() != null) {
                        request.addParameter("Dimensions.member." + dimensionsListIndex + ".Value", StringUtils.fromString((String)dimensionsListValue.value()));
                    }
                    ++dimensionsListIndex;
                }
            } else {
                request.addParameter("Dimensions", "");
            }
        }
        if (listMetricsRequest.nextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)listMetricsRequest.nextToken()));
        }
        return request;
    }
}

