/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.List;
import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudwatch.model.EnableAlarmActionsRequest;

public class EnableAlarmActionsRequestMarshaller
implements Marshaller<Request<EnableAlarmActionsRequest>, EnableAlarmActionsRequest> {
    public Request<EnableAlarmActionsRequest> marshall(EnableAlarmActionsRequest enableAlarmActionsRequest) {
        if (enableAlarmActionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)enableAlarmActionsRequest, "CloudWatchClient");
        request.addParameter("Action", "EnableAlarmActions");
        request.addParameter("Version", "2010-08-01");
        request.setHttpMethod(HttpMethodName.POST);
        List<String> alarmNamesList = enableAlarmActionsRequest.alarmNames();
        if (alarmNamesList != null) {
            if (!alarmNamesList.isEmpty()) {
                int alarmNamesListIndex = 1;
                for (String alarmNamesListValue : alarmNamesList) {
                    if (alarmNamesListValue != null) {
                        request.addParameter("AlarmNames.member." + alarmNamesListIndex, StringUtils.fromString((String)alarmNamesListValue));
                    }
                    ++alarmNamesListIndex;
                }
            } else {
                request.addParameter("AlarmNames", "");
            }
        }
        return request;
    }
}

