/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.StatisticSet;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class MetricDatum
implements ToCopyableBuilder<Builder, MetricDatum> {
    private final String metricName;
    private final List<Dimension> dimensions;
    private final Instant timestamp;
    private final Double value;
    private final StatisticSet statisticValues;
    private final String unit;

    private MetricDatum(BuilderImpl builder) {
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.timestamp = builder.timestamp;
        this.value = builder.value;
        this.statisticValues = builder.statisticValues;
        this.unit = builder.unit;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Instant timestamp() {
        return this.timestamp;
    }

    public Double value() {
        return this.value;
    }

    public StatisticSet statisticValues() {
        return this.statisticValues;
    }

    public StandardUnit unit() {
        return StandardUnit.fromValue(this.unit);
    }

    public String unitString() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.dimensions() == null ? 0 : this.dimensions().hashCode());
        hashCode = 31 * hashCode + (this.timestamp() == null ? 0 : this.timestamp().hashCode());
        hashCode = 31 * hashCode + (this.value() == null ? 0 : this.value().hashCode());
        hashCode = 31 * hashCode + (this.statisticValues() == null ? 0 : this.statisticValues().hashCode());
        hashCode = 31 * hashCode + (this.unitString() == null ? 0 : this.unitString().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetricDatum)) {
            return false;
        }
        MetricDatum other = (MetricDatum)obj;
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.timestamp() == null ^ this.timestamp() == null) {
            return false;
        }
        if (other.timestamp() != null && !other.timestamp().equals(this.timestamp())) {
            return false;
        }
        if (other.value() == null ^ this.value() == null) {
            return false;
        }
        if (other.value() != null && !other.value().equals(this.value())) {
            return false;
        }
        if (other.statisticValues() == null ^ this.statisticValues() == null) {
            return false;
        }
        if (other.statisticValues() != null && !other.statisticValues().equals(this.statisticValues())) {
            return false;
        }
        if (other.unitString() == null ^ this.unitString() == null) {
            return false;
        }
        return other.unitString() == null || other.unitString().equals(this.unitString());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.timestamp() != null) {
            sb.append("Timestamp: ").append(this.timestamp()).append(",");
        }
        if (this.value() != null) {
            sb.append("Value: ").append(this.value()).append(",");
        }
        if (this.statisticValues() != null) {
            sb.append("StatisticValues: ").append(this.statisticValues()).append(",");
        }
        if (this.unitString() != null) {
            sb.append("Unit: ").append(this.unitString()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetricName": {
                return Optional.of(clazz.cast(this.metricName()));
            }
            case "Dimensions": {
                return Optional.of(clazz.cast(this.dimensions()));
            }
            case "Timestamp": {
                return Optional.of(clazz.cast(this.timestamp()));
            }
            case "Value": {
                return Optional.of(clazz.cast(this.value()));
            }
            case "StatisticValues": {
                return Optional.of(clazz.cast(this.statisticValues()));
            }
            case "Unit": {
                return Optional.of(clazz.cast(this.unitString()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String metricName;
        private List<Dimension> dimensions;
        private Instant timestamp;
        private Double value;
        private StatisticSet statisticValues;
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(MetricDatum model) {
            this.metricName(model.metricName);
            this.dimensions(model.dimensions);
            this.timestamp(model.timestamp);
            this.value(model.value);
            this.statisticValues(model.statisticValues);
            this.unit(model.unit);
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Dimension.Builder> getDimensions() {
            return this.dimensions != null ? (Collection)this.dimensions.stream().map(Dimension::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            this.dimensions(Arrays.asList(dimensions));
            return this;
        }

        public final void setDimensions(Collection<Dimension.BuilderImpl> dimensions) {
            this.dimensions = DimensionsCopier.copyFromBuilder(dimensions);
        }

        public final Instant getTimestamp() {
            return this.timestamp;
        }

        @Override
        public final Builder timestamp(Instant timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public final void setTimestamp(Instant timestamp) {
            this.timestamp = timestamp;
        }

        public final Double getValue() {
            return this.value;
        }

        @Override
        public final Builder value(Double value) {
            this.value = value;
            return this;
        }

        public final void setValue(Double value) {
            this.value = value;
        }

        public final StatisticSet.Builder getStatisticValues() {
            return this.statisticValues != null ? this.statisticValues.toBuilder() : null;
        }

        @Override
        public final Builder statisticValues(StatisticSet statisticValues) {
            this.statisticValues = statisticValues;
            return this;
        }

        public final void setStatisticValues(StatisticSet.BuilderImpl statisticValues) {
            this.statisticValues = statisticValues != null ? statisticValues.build() : null;
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public MetricDatum build() {
            return new MetricDatum(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MetricDatum> {
        public Builder metricName(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder timestamp(Instant var1);

        public Builder value(Double var1);

        public Builder statisticValues(StatisticSet var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);
    }
}

