/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.Metric;
import software.amazon.awssdk.services.cloudwatch.transform.DimensionUnmarshaller;

public class MetricUnmarshaller
implements Unmarshaller<Metric, StaxUnmarshallerContext> {
    private static final MetricUnmarshaller INSTANCE = new MetricUnmarshaller();

    public Metric unmarshall(StaxUnmarshallerContext context) throws Exception {
        Metric.Builder metric;
        block7: {
            metric = Metric.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            ArrayList<Dimension> dimensions = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    metric.dimensions(dimensions);
                    break block7;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Namespace", targetDepth)) {
                        metric.namespace(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("MetricName", targetDepth)) {
                        metric.metricName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Dimensions", targetDepth)) {
                        dimensions = new ArrayList<Dimension>();
                        continue;
                    }
                    if (!context.testExpression("Dimensions/member", targetDepth)) continue;
                    dimensions.add(DimensionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            metric.dimensions(dimensions);
        }
        return (Metric)metric.build();
    }

    public static MetricUnmarshaller getInstance() {
        return INSTANCE;
    }
}

