/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.MapEntry;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;

public class DatapointUnmarshaller
implements Unmarshaller<Datapoint, StaxUnmarshallerContext> {
    private static final DatapointUnmarshaller INSTANCE = new DatapointUnmarshaller();

    public Datapoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        Datapoint.Builder datapoint;
        block12: {
            datapoint = Datapoint.builder();
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            if (context.isStartOfDocument()) {
                ++targetDepth;
            }
            HashMap<String, Double> extendedStatistics = null;
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    datapoint.extendedStatistics(extendedStatistics);
                    break block12;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("Timestamp", targetDepth)) {
                        datapoint.timestamp(SimpleTypeStaxUnmarshallers.InstantUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("SampleCount", targetDepth)) {
                        datapoint.sampleCount(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Average", targetDepth)) {
                        datapoint.average(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Sum", targetDepth)) {
                        datapoint.sum(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Minimum", targetDepth)) {
                        datapoint.minimum(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Maximum", targetDepth)) {
                        datapoint.maximum(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (context.testExpression("Unit", targetDepth)) {
                        datapoint.unit(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("ExtendedStatistics/entry", targetDepth)) continue;
                    if (extendedStatistics == null) {
                        extendedStatistics = new HashMap<String, Double>();
                    }
                    Map.Entry<String, Double> entry = ExtendedStatisticsMapEntryUnmarshaller.getInstance().unmarshall(context);
                    extendedStatistics.put(entry.getKey(), entry.getValue());
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            datapoint.extendedStatistics(extendedStatistics);
        }
        return (Datapoint)datapoint.build();
    }

    public static DatapointUnmarshaller getInstance() {
        return INSTANCE;
    }

    private static class ExtendedStatisticsMapEntryUnmarshaller
    implements Unmarshaller<Map.Entry<String, Double>, StaxUnmarshallerContext> {
        private static final ExtendedStatisticsMapEntryUnmarshaller INSTANCE = new ExtendedStatisticsMapEntryUnmarshaller();

        private ExtendedStatisticsMapEntryUnmarshaller() {
        }

        public Map.Entry<String, Double> unmarshall(StaxUnmarshallerContext context) throws Exception {
            int originalDepth = context.getCurrentDepth();
            int targetDepth = originalDepth + 1;
            MapEntry entry = new MapEntry();
            while (true) {
                XMLEvent xmlEvent;
                if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                    return entry;
                }
                if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                    if (context.testExpression("key", targetDepth)) {
                        entry.setKey((Object)SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                        continue;
                    }
                    if (!context.testExpression("value", targetDepth)) continue;
                    entry.setValue((Object)SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
            }
            return entry;
        }

        public static ExtendedStatisticsMapEntryUnmarshaller getInstance() {
            return INSTANCE;
        }
    }
}

