/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.cloudwatch.model.Datapoint;
import software.amazon.awssdk.services.cloudwatch.model.DatapointsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMetricStatisticsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, GetMetricStatisticsResponse> {
    private final String label;
    private final List<Datapoint> datapoints;

    private GetMetricStatisticsResponse(BuilderImpl builder) {
        this.label = builder.label;
        this.datapoints = builder.datapoints;
    }

    public String label() {
        return this.label;
    }

    public List<Datapoint> datapoints() {
        return this.datapoints;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.label() == null ? 0 : this.label().hashCode());
        hashCode = 31 * hashCode + (this.datapoints() == null ? 0 : this.datapoints().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsResponse)) {
            return false;
        }
        GetMetricStatisticsResponse other = (GetMetricStatisticsResponse)((Object)obj);
        if (other.label() == null ^ this.label() == null) {
            return false;
        }
        if (other.label() != null && !other.label().equals(this.label())) {
            return false;
        }
        if (other.datapoints() == null ^ this.datapoints() == null) {
            return false;
        }
        return other.datapoints() == null || other.datapoints().equals(this.datapoints());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.label() != null) {
            sb.append("Label: ").append(this.label()).append(",");
        }
        if (this.datapoints() != null) {
            sb.append("Datapoints: ").append(this.datapoints()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String label;
        private List<Datapoint> datapoints;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsResponse model) {
            this.setLabel(model.label);
            this.setDatapoints(model.datapoints);
        }

        public final String getLabel() {
            return this.label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        public final Collection<Datapoint> getDatapoints() {
            return this.datapoints;
        }

        @Override
        public final Builder datapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder datapoints(Datapoint ... datapoints) {
            this.datapoints(Arrays.asList(datapoints));
            return this;
        }

        public final void setDatapoints(Collection<Datapoint> datapoints) {
            this.datapoints = DatapointsCopier.copy(datapoints);
        }

        public GetMetricStatisticsResponse build() {
            return new GetMetricStatisticsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetMetricStatisticsResponse> {
        public Builder label(String var1);

        public Builder datapoints(Collection<Datapoint> var1);

        public Builder datapoints(Datapoint ... var1);
    }
}

