/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.transform;

import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.MetricDatum;
import software.amazon.awssdk.services.cloudwatch.transform.DimensionUnmarshaller;
import software.amazon.awssdk.services.cloudwatch.transform.StatisticSetUnmarshaller;

public class MetricDatumUnmarshaller
implements Unmarshaller<MetricDatum, StaxUnmarshallerContext> {
    private static MetricDatumUnmarshaller INSTANCE;

    public MetricDatum unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        MetricDatum.Builder metricDatum = MetricDatum.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("MetricName", targetDepth)) {
                    metricDatum.metricName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Dimensions", targetDepth)) {
                    metricDatum.dimensions(new ArrayList<Dimension>());
                    continue;
                }
                if (context.testExpression("Dimensions/member", targetDepth)) {
                    metricDatum.dimensions(DimensionUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Timestamp", targetDepth)) {
                    metricDatum.timestamp(SimpleTypeStaxUnmarshallers.DateUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Value", targetDepth)) {
                    metricDatum.value(SimpleTypeStaxUnmarshallers.DoubleUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("StatisticValues", targetDepth)) {
                    metricDatum.statisticValues(StatisticSetUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Unit", targetDepth)) continue;
                metricDatum.unit(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (MetricDatum)metricDatum.build();
    }

    public static MetricDatumUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MetricDatumUnmarshaller();
        }
        return INSTANCE;
    }
}

