/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudwatch.model;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceRequest;
import software.amazon.awssdk.runtime.SdkInternalList;
import software.amazon.awssdk.runtime.StandardMemberCopier;
import software.amazon.awssdk.services.cloudwatch.model.Dimension;
import software.amazon.awssdk.services.cloudwatch.model.DimensionsCopier;
import software.amazon.awssdk.services.cloudwatch.model.ExtendedStatisticsCopier;
import software.amazon.awssdk.services.cloudwatch.model.StandardUnit;
import software.amazon.awssdk.services.cloudwatch.model.Statistic;
import software.amazon.awssdk.services.cloudwatch.model.StatisticsCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class GetMetricStatisticsRequest
extends AmazonWebServiceRequest
implements ToCopyableBuilder<Builder, GetMetricStatisticsRequest> {
    private final String namespace;
    private final String metricName;
    private final List<Dimension> dimensions;
    private final Date startTime;
    private final Date endTime;
    private final Integer period;
    private final List<String> statistics;
    private final List<String> extendedStatistics;
    private final String unit;

    private GetMetricStatisticsRequest(BuilderImpl builder) {
        this.namespace = builder.namespace;
        this.metricName = builder.metricName;
        this.dimensions = builder.dimensions;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.period = builder.period;
        this.statistics = builder.statistics;
        this.extendedStatistics = builder.extendedStatistics;
        this.unit = builder.unit;
    }

    public String namespace() {
        return this.namespace;
    }

    public String metricName() {
        return this.metricName;
    }

    public List<Dimension> dimensions() {
        return this.dimensions;
    }

    public Date startTime() {
        return this.startTime;
    }

    public Date endTime() {
        return this.endTime;
    }

    public Integer period() {
        return this.period;
    }

    public List<String> statistics() {
        return this.statistics;
    }

    public List<String> extendedStatistics() {
        return this.extendedStatistics;
    }

    public String unit() {
        return this.unit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.namespace() == null ? 0 : this.namespace().hashCode());
        hashCode = 31 * hashCode + (this.metricName() == null ? 0 : this.metricName().hashCode());
        hashCode = 31 * hashCode + (this.dimensions() == null ? 0 : this.dimensions().hashCode());
        hashCode = 31 * hashCode + (this.startTime() == null ? 0 : this.startTime().hashCode());
        hashCode = 31 * hashCode + (this.endTime() == null ? 0 : this.endTime().hashCode());
        hashCode = 31 * hashCode + (this.period() == null ? 0 : this.period().hashCode());
        hashCode = 31 * hashCode + (this.statistics() == null ? 0 : this.statistics().hashCode());
        hashCode = 31 * hashCode + (this.extendedStatistics() == null ? 0 : this.extendedStatistics().hashCode());
        hashCode = 31 * hashCode + (this.unit() == null ? 0 : this.unit().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetMetricStatisticsRequest)) {
            return false;
        }
        GetMetricStatisticsRequest other = (GetMetricStatisticsRequest)((Object)obj);
        if (other.namespace() == null ^ this.namespace() == null) {
            return false;
        }
        if (other.namespace() != null && !other.namespace().equals(this.namespace())) {
            return false;
        }
        if (other.metricName() == null ^ this.metricName() == null) {
            return false;
        }
        if (other.metricName() != null && !other.metricName().equals(this.metricName())) {
            return false;
        }
        if (other.dimensions() == null ^ this.dimensions() == null) {
            return false;
        }
        if (other.dimensions() != null && !other.dimensions().equals(this.dimensions())) {
            return false;
        }
        if (other.startTime() == null ^ this.startTime() == null) {
            return false;
        }
        if (other.startTime() != null && !other.startTime().equals(this.startTime())) {
            return false;
        }
        if (other.endTime() == null ^ this.endTime() == null) {
            return false;
        }
        if (other.endTime() != null && !other.endTime().equals(this.endTime())) {
            return false;
        }
        if (other.period() == null ^ this.period() == null) {
            return false;
        }
        if (other.period() != null && !other.period().equals(this.period())) {
            return false;
        }
        if (other.statistics() == null ^ this.statistics() == null) {
            return false;
        }
        if (other.statistics() != null && !other.statistics().equals(this.statistics())) {
            return false;
        }
        if (other.extendedStatistics() == null ^ this.extendedStatistics() == null) {
            return false;
        }
        if (other.extendedStatistics() != null && !other.extendedStatistics().equals(this.extendedStatistics())) {
            return false;
        }
        if (other.unit() == null ^ this.unit() == null) {
            return false;
        }
        return other.unit() == null || other.unit().equals(this.unit());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.namespace() != null) {
            sb.append("Namespace: ").append(this.namespace()).append(",");
        }
        if (this.metricName() != null) {
            sb.append("MetricName: ").append(this.metricName()).append(",");
        }
        if (this.dimensions() != null) {
            sb.append("Dimensions: ").append(this.dimensions()).append(",");
        }
        if (this.startTime() != null) {
            sb.append("StartTime: ").append(this.startTime()).append(",");
        }
        if (this.endTime() != null) {
            sb.append("EndTime: ").append(this.endTime()).append(",");
        }
        if (this.period() != null) {
            sb.append("Period: ").append(this.period()).append(",");
        }
        if (this.statistics() != null) {
            sb.append("Statistics: ").append(this.statistics()).append(",");
        }
        if (this.extendedStatistics() != null) {
            sb.append("ExtendedStatistics: ").append(this.extendedStatistics()).append(",");
        }
        if (this.unit() != null) {
            sb.append("Unit: ").append(this.unit()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String namespace;
        private String metricName;
        private List<Dimension> dimensions = new SdkInternalList();
        private Date startTime;
        private Date endTime;
        private Integer period;
        private List<String> statistics = new SdkInternalList();
        private List<String> extendedStatistics = new SdkInternalList();
        private String unit;

        private BuilderImpl() {
        }

        private BuilderImpl(GetMetricStatisticsRequest model) {
            this.setNamespace(model.namespace);
            this.setMetricName(model.metricName);
            this.setDimensions(model.dimensions);
            this.setStartTime(model.startTime);
            this.setEndTime(model.endTime);
            this.setPeriod(model.period);
            this.setStatistics(model.statistics);
            this.setExtendedStatistics(model.extendedStatistics);
            this.setUnit(model.unit);
        }

        public final String getNamespace() {
            return this.namespace;
        }

        @Override
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        public final String getMetricName() {
            return this.metricName;
        }

        @Override
        public final Builder metricName(String metricName) {
            this.metricName = metricName;
            return this;
        }

        public final void setMetricName(String metricName) {
            this.metricName = metricName;
        }

        public final Collection<Dimension> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final Builder dimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dimensions(Dimension ... dimensions) {
            if (this.dimensions == null) {
                this.dimensions = new SdkInternalList(dimensions.length);
            }
            for (Dimension e : dimensions) {
                this.dimensions.add(e);
            }
            return this;
        }

        public final void setDimensions(Collection<Dimension> dimensions) {
            this.dimensions = DimensionsCopier.copy(dimensions);
        }

        @SafeVarargs
        public final void setDimensions(Dimension ... dimensions) {
            if (this.dimensions == null) {
                this.dimensions = new SdkInternalList(dimensions.length);
            }
            for (Dimension e : dimensions) {
                this.dimensions.add(e);
            }
        }

        public final Date getStartTime() {
            return this.startTime;
        }

        @Override
        public final Builder startTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
            return this;
        }

        public final void setStartTime(Date startTime) {
            this.startTime = StandardMemberCopier.copy((Date)startTime);
        }

        public final Date getEndTime() {
            return this.endTime;
        }

        @Override
        public final Builder endTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
            return this;
        }

        public final void setEndTime(Date endTime) {
            this.endTime = StandardMemberCopier.copy((Date)endTime);
        }

        public final Integer getPeriod() {
            return this.period;
        }

        @Override
        public final Builder period(Integer period) {
            this.period = period;
            return this;
        }

        public final void setPeriod(Integer period) {
            this.period = period;
        }

        public final Collection<String> getStatistics() {
            return this.statistics;
        }

        @Override
        public final Builder statistics(Collection<String> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(String ... statistics) {
            if (this.statistics == null) {
                this.statistics = new SdkInternalList(statistics.length);
            }
            for (String e : statistics) {
                this.statistics.add(e);
            }
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(Statistic ... statistics) {
            if (this.statistics == null) {
                this.statistics = new SdkInternalList(statistics.length);
            }
            for (Statistic ele : statistics) {
                this.statistics.add(ele.toString());
            }
            return this;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = StatisticsCopier.copy(statistics);
        }

        @SafeVarargs
        public final void setStatistics(String ... statistics) {
            if (this.statistics == null) {
                this.statistics = new SdkInternalList(statistics.length);
            }
            for (String e : statistics) {
                this.statistics.add(e);
            }
        }

        @SafeVarargs
        public final void setStatistics(Statistic ... statistics) {
            if (this.statistics == null) {
                this.statistics = new SdkInternalList(statistics.length);
            }
            for (Statistic ele : statistics) {
                this.statistics.add(ele.toString());
            }
        }

        public final Collection<String> getExtendedStatistics() {
            return this.extendedStatistics;
        }

        @Override
        public final Builder extendedStatistics(Collection<String> extendedStatistics) {
            this.extendedStatistics = ExtendedStatisticsCopier.copy(extendedStatistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extendedStatistics(String ... extendedStatistics) {
            if (this.extendedStatistics == null) {
                this.extendedStatistics = new SdkInternalList(extendedStatistics.length);
            }
            for (String e : extendedStatistics) {
                this.extendedStatistics.add(e);
            }
            return this;
        }

        public final void setExtendedStatistics(Collection<String> extendedStatistics) {
            this.extendedStatistics = ExtendedStatisticsCopier.copy(extendedStatistics);
        }

        @SafeVarargs
        public final void setExtendedStatistics(String ... extendedStatistics) {
            if (this.extendedStatistics == null) {
                this.extendedStatistics = new SdkInternalList(extendedStatistics.length);
            }
            for (String e : extendedStatistics) {
                this.extendedStatistics.add(e);
            }
        }

        public final String getUnit() {
            return this.unit;
        }

        @Override
        public final Builder unit(String unit) {
            this.unit = unit;
            return this;
        }

        @Override
        public final Builder unit(StandardUnit unit) {
            this.unit(unit.toString());
            return this;
        }

        public final void setUnit(String unit) {
            this.unit = unit;
        }

        public final void setUnit(StandardUnit unit) {
            this.unit(unit.toString());
        }

        public GetMetricStatisticsRequest build() {
            return new GetMetricStatisticsRequest(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, GetMetricStatisticsRequest> {
        public Builder namespace(String var1);

        public Builder metricName(String var1);

        public Builder dimensions(Collection<Dimension> var1);

        public Builder dimensions(Dimension ... var1);

        public Builder startTime(Date var1);

        public Builder endTime(Date var1);

        public Builder period(Integer var1);

        public Builder statistics(Collection<String> var1);

        public Builder statistics(String ... var1);

        public Builder statistics(Statistic ... var1);

        public Builder extendedStatistics(Collection<String> var1);

        public Builder extendedStatistics(String ... var1);

        public Builder unit(String var1);

        public Builder unit(StandardUnit var1);
    }
}

