/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.Event;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsDataRequest;
import software.amazon.awssdk.services.cloudtrail.model.ListInsightsDataResponse;

public class ListInsightsDataIterable
implements SdkIterable<ListInsightsDataResponse> {
    private final CloudTrailClient client;
    private final ListInsightsDataRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListInsightsDataIterable(CloudTrailClient client, ListInsightsDataRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListInsightsDataResponseFetcher();
    }

    public Iterator<ListInsightsDataResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Event> events() {
        Function<ListInsightsDataResponse, Iterator> getIterator = response -> {
            if (response != null && response.events() != null) {
                return response.events().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListInsightsDataResponseFetcher
    implements SyncPageFetcher<ListInsightsDataResponse> {
        private ListInsightsDataResponseFetcher() {
        }

        public boolean hasNextPage(ListInsightsDataResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListInsightsDataResponse nextPage(ListInsightsDataResponse previousPage) {
            if (previousPage == null) {
                return ListInsightsDataIterable.this.client.listInsightsData(ListInsightsDataIterable.this.firstRequest);
            }
            return ListInsightsDataIterable.this.client.listInsightsData((ListInsightsDataRequest)((Object)ListInsightsDataIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

