/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudtrail.model.AggregationConfiguration;
import software.amazon.awssdk.services.cloudtrail.model.AggregationConfigurationsCopier;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailRequest;
import software.amazon.awssdk.services.cloudtrail.model.ContextKeySelector;
import software.amazon.awssdk.services.cloudtrail.model.ContextKeySelectorsCopier;
import software.amazon.awssdk.services.cloudtrail.model.MaxEventSize;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutEventConfigurationRequest
extends CloudTrailRequest
implements ToCopyableBuilder<Builder, PutEventConfigurationRequest> {
    private static final SdkField<String> TRAIL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrailName").getter(PutEventConfigurationRequest.getter(PutEventConfigurationRequest::trailName)).setter(PutEventConfigurationRequest.setter(Builder::trailName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrailName").build()}).build();
    private static final SdkField<String> EVENT_DATA_STORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStore").getter(PutEventConfigurationRequest.getter(PutEventConfigurationRequest::eventDataStore)).setter(PutEventConfigurationRequest.setter(Builder::eventDataStore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStore").build()}).build();
    private static final SdkField<String> MAX_EVENT_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaxEventSize").getter(PutEventConfigurationRequest.getter(PutEventConfigurationRequest::maxEventSizeAsString)).setter(PutEventConfigurationRequest.setter(Builder::maxEventSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxEventSize").build()}).build();
    private static final SdkField<List<ContextKeySelector>> CONTEXT_KEY_SELECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ContextKeySelectors").getter(PutEventConfigurationRequest.getter(PutEventConfigurationRequest::contextKeySelectors)).setter(PutEventConfigurationRequest.setter(Builder::contextKeySelectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextKeySelectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContextKeySelector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<AggregationConfiguration>> AGGREGATION_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("AggregationConfigurations").getter(PutEventConfigurationRequest.getter(PutEventConfigurationRequest::aggregationConfigurations)).setter(PutEventConfigurationRequest.setter(Builder::aggregationConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AggregationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAIL_NAME_FIELD, EVENT_DATA_STORE_FIELD, MAX_EVENT_SIZE_FIELD, CONTEXT_KEY_SELECTORS_FIELD, AGGREGATION_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PutEventConfigurationRequest.memberNameToFieldInitializer();
    private final String trailName;
    private final String eventDataStore;
    private final String maxEventSize;
    private final List<ContextKeySelector> contextKeySelectors;
    private final List<AggregationConfiguration> aggregationConfigurations;

    private PutEventConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.trailName = builder.trailName;
        this.eventDataStore = builder.eventDataStore;
        this.maxEventSize = builder.maxEventSize;
        this.contextKeySelectors = builder.contextKeySelectors;
        this.aggregationConfigurations = builder.aggregationConfigurations;
    }

    public final String trailName() {
        return this.trailName;
    }

    public final String eventDataStore() {
        return this.eventDataStore;
    }

    public final MaxEventSize maxEventSize() {
        return MaxEventSize.fromValue(this.maxEventSize);
    }

    public final String maxEventSizeAsString() {
        return this.maxEventSize;
    }

    public final boolean hasContextKeySelectors() {
        return this.contextKeySelectors != null && !(this.contextKeySelectors instanceof SdkAutoConstructList);
    }

    public final List<ContextKeySelector> contextKeySelectors() {
        return this.contextKeySelectors;
    }

    public final boolean hasAggregationConfigurations() {
        return this.aggregationConfigurations != null && !(this.aggregationConfigurations instanceof SdkAutoConstructList);
    }

    public final List<AggregationConfiguration> aggregationConfigurations() {
        return this.aggregationConfigurations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.trailName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStore());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxEventSizeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasContextKeySelectors() ? this.contextKeySelectors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAggregationConfigurations() ? this.aggregationConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutEventConfigurationRequest)) {
            return false;
        }
        PutEventConfigurationRequest other = (PutEventConfigurationRequest)((Object)obj);
        return Objects.equals(this.trailName(), other.trailName()) && Objects.equals(this.eventDataStore(), other.eventDataStore()) && Objects.equals(this.maxEventSizeAsString(), other.maxEventSizeAsString()) && this.hasContextKeySelectors() == other.hasContextKeySelectors() && Objects.equals(this.contextKeySelectors(), other.contextKeySelectors()) && this.hasAggregationConfigurations() == other.hasAggregationConfigurations() && Objects.equals(this.aggregationConfigurations(), other.aggregationConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"PutEventConfigurationRequest").add("TrailName", (Object)this.trailName()).add("EventDataStore", (Object)this.eventDataStore()).add("MaxEventSize", (Object)this.maxEventSizeAsString()).add("ContextKeySelectors", this.hasContextKeySelectors() ? this.contextKeySelectors() : null).add("AggregationConfigurations", this.hasAggregationConfigurations() ? this.aggregationConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrailName": {
                return Optional.ofNullable(clazz.cast(this.trailName()));
            }
            case "EventDataStore": {
                return Optional.ofNullable(clazz.cast(this.eventDataStore()));
            }
            case "MaxEventSize": {
                return Optional.ofNullable(clazz.cast(this.maxEventSizeAsString()));
            }
            case "ContextKeySelectors": {
                return Optional.ofNullable(clazz.cast(this.contextKeySelectors()));
            }
            case "AggregationConfigurations": {
                return Optional.ofNullable(clazz.cast(this.aggregationConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrailName", TRAIL_NAME_FIELD);
        map.put("EventDataStore", EVENT_DATA_STORE_FIELD);
        map.put("MaxEventSize", MAX_EVENT_SIZE_FIELD);
        map.put("ContextKeySelectors", CONTEXT_KEY_SELECTORS_FIELD);
        map.put("AggregationConfigurations", AGGREGATION_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutEventConfigurationRequest, T> g) {
        return obj -> g.apply((PutEventConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailRequest.BuilderImpl
    implements Builder {
        private String trailName;
        private String eventDataStore;
        private String maxEventSize;
        private List<ContextKeySelector> contextKeySelectors = DefaultSdkAutoConstructList.getInstance();
        private List<AggregationConfiguration> aggregationConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PutEventConfigurationRequest model) {
            super(model);
            this.trailName(model.trailName);
            this.eventDataStore(model.eventDataStore);
            this.maxEventSize(model.maxEventSize);
            this.contextKeySelectors(model.contextKeySelectors);
            this.aggregationConfigurations(model.aggregationConfigurations);
        }

        public final String getTrailName() {
            return this.trailName;
        }

        public final void setTrailName(String trailName) {
            this.trailName = trailName;
        }

        @Override
        public final Builder trailName(String trailName) {
            this.trailName = trailName;
            return this;
        }

        public final String getEventDataStore() {
            return this.eventDataStore;
        }

        public final void setEventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
        }

        @Override
        public final Builder eventDataStore(String eventDataStore) {
            this.eventDataStore = eventDataStore;
            return this;
        }

        public final String getMaxEventSize() {
            return this.maxEventSize;
        }

        public final void setMaxEventSize(String maxEventSize) {
            this.maxEventSize = maxEventSize;
        }

        @Override
        public final Builder maxEventSize(String maxEventSize) {
            this.maxEventSize = maxEventSize;
            return this;
        }

        @Override
        public final Builder maxEventSize(MaxEventSize maxEventSize) {
            this.maxEventSize(maxEventSize == null ? null : maxEventSize.toString());
            return this;
        }

        public final List<ContextKeySelector.Builder> getContextKeySelectors() {
            List<ContextKeySelector.Builder> result = ContextKeySelectorsCopier.copyToBuilder(this.contextKeySelectors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContextKeySelectors(Collection<ContextKeySelector.BuilderImpl> contextKeySelectors) {
            this.contextKeySelectors = ContextKeySelectorsCopier.copyFromBuilder(contextKeySelectors);
        }

        @Override
        public final Builder contextKeySelectors(Collection<ContextKeySelector> contextKeySelectors) {
            this.contextKeySelectors = ContextKeySelectorsCopier.copy(contextKeySelectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeySelectors(ContextKeySelector ... contextKeySelectors) {
            this.contextKeySelectors(Arrays.asList(contextKeySelectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextKeySelectors(Consumer<ContextKeySelector.Builder> ... contextKeySelectors) {
            this.contextKeySelectors(Stream.of(contextKeySelectors).map(c -> (ContextKeySelector)((ContextKeySelector.Builder)ContextKeySelector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<AggregationConfiguration.Builder> getAggregationConfigurations() {
            List<AggregationConfiguration.Builder> result = AggregationConfigurationsCopier.copyToBuilder(this.aggregationConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAggregationConfigurations(Collection<AggregationConfiguration.BuilderImpl> aggregationConfigurations) {
            this.aggregationConfigurations = AggregationConfigurationsCopier.copyFromBuilder(aggregationConfigurations);
        }

        @Override
        public final Builder aggregationConfigurations(Collection<AggregationConfiguration> aggregationConfigurations) {
            this.aggregationConfigurations = AggregationConfigurationsCopier.copy(aggregationConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationConfigurations(AggregationConfiguration ... aggregationConfigurations) {
            this.aggregationConfigurations(Arrays.asList(aggregationConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aggregationConfigurations(Consumer<AggregationConfiguration.Builder> ... aggregationConfigurations) {
            this.aggregationConfigurations(Stream.of(aggregationConfigurations).map(c -> (AggregationConfiguration)((AggregationConfiguration.Builder)AggregationConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutEventConfigurationRequest build() {
            return new PutEventConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends CloudTrailRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutEventConfigurationRequest> {
        public Builder trailName(String var1);

        public Builder eventDataStore(String var1);

        public Builder maxEventSize(String var1);

        public Builder maxEventSize(MaxEventSize var1);

        public Builder contextKeySelectors(Collection<ContextKeySelector> var1);

        public Builder contextKeySelectors(ContextKeySelector ... var1);

        public Builder contextKeySelectors(Consumer<ContextKeySelector.Builder> ... var1);

        public Builder aggregationConfigurations(Collection<AggregationConfiguration> var1);

        public Builder aggregationConfigurations(AggregationConfiguration ... var1);

        public Builder aggregationConfigurations(Consumer<AggregationConfiguration.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

