/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudtrail.model.CloudTrailResponse;
import software.amazon.awssdk.services.cloudtrail.model.FederationStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DisableFederationResponse
extends CloudTrailResponse
implements ToCopyableBuilder<Builder, DisableFederationResponse> {
    private static final SdkField<String> EVENT_DATA_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventDataStoreArn").getter(DisableFederationResponse.getter(DisableFederationResponse::eventDataStoreArn)).setter(DisableFederationResponse.setter(Builder::eventDataStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventDataStoreArn").build()}).build();
    private static final SdkField<String> FEDERATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FederationStatus").getter(DisableFederationResponse.getter(DisableFederationResponse::federationStatusAsString)).setter(DisableFederationResponse.setter(Builder::federationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FederationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_DATA_STORE_ARN_FIELD, FEDERATION_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("EventDataStoreArn", EVENT_DATA_STORE_ARN_FIELD);
            this.put("FederationStatus", FEDERATION_STATUS_FIELD);
        }
    });
    private final String eventDataStoreArn;
    private final String federationStatus;

    private DisableFederationResponse(BuilderImpl builder) {
        super(builder);
        this.eventDataStoreArn = builder.eventDataStoreArn;
        this.federationStatus = builder.federationStatus;
    }

    public final String eventDataStoreArn() {
        return this.eventDataStoreArn;
    }

    public final FederationStatus federationStatus() {
        return FederationStatus.fromValue(this.federationStatus);
    }

    public final String federationStatusAsString() {
        return this.federationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventDataStoreArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.federationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisableFederationResponse)) {
            return false;
        }
        DisableFederationResponse other = (DisableFederationResponse)((Object)obj);
        return Objects.equals(this.eventDataStoreArn(), other.eventDataStoreArn()) && Objects.equals(this.federationStatusAsString(), other.federationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DisableFederationResponse").add("EventDataStoreArn", (Object)this.eventDataStoreArn()).add("FederationStatus", (Object)this.federationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EventDataStoreArn": {
                return Optional.ofNullable(clazz.cast(this.eventDataStoreArn()));
            }
            case "FederationStatus": {
                return Optional.ofNullable(clazz.cast(this.federationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DisableFederationResponse, T> g) {
        return obj -> g.apply((DisableFederationResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudTrailResponse.BuilderImpl
    implements Builder {
        private String eventDataStoreArn;
        private String federationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(DisableFederationResponse model) {
            super(model);
            this.eventDataStoreArn(model.eventDataStoreArn);
            this.federationStatus(model.federationStatus);
        }

        public final String getEventDataStoreArn() {
            return this.eventDataStoreArn;
        }

        public final void setEventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
        }

        @Override
        public final Builder eventDataStoreArn(String eventDataStoreArn) {
            this.eventDataStoreArn = eventDataStoreArn;
            return this;
        }

        public final String getFederationStatus() {
            return this.federationStatus;
        }

        public final void setFederationStatus(String federationStatus) {
            this.federationStatus = federationStatus;
        }

        @Override
        public final Builder federationStatus(String federationStatus) {
            this.federationStatus = federationStatus;
            return this;
        }

        @Override
        public final Builder federationStatus(FederationStatus federationStatus) {
            this.federationStatus(federationStatus == null ? null : federationStatus.toString());
            return this;
        }

        @Override
        public DisableFederationResponse build() {
            return new DisableFederationResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudTrailResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DisableFederationResponse> {
        public Builder eventDataStoreArn(String var1);

        public Builder federationStatus(String var1);

        public Builder federationStatus(FederationStatus var1);
    }
}

