/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudtrail.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.cloudtrail.CloudTrailAsyncClient;
import software.amazon.awssdk.services.cloudtrail.internal.UserAgentUtils;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.cloudtrail.model.GetQueryResultsResponse;

public class GetQueryResultsPublisher
implements SdkPublisher<GetQueryResultsResponse> {
    private final CloudTrailAsyncClient client;
    private final GetQueryResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetQueryResultsPublisher(CloudTrailAsyncClient client, GetQueryResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetQueryResultsPublisher(CloudTrailAsyncClient client, GetQueryResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetQueryResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetQueryResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetQueryResultsResponseFetcher
    implements AsyncPageFetcher<GetQueryResultsResponse> {
        private GetQueryResultsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetQueryResultsResponse> nextPage(GetQueryResultsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsPublisher.this.client.getQueryResults(GetQueryResultsPublisher.this.firstRequest);
            }
            return GetQueryResultsPublisher.this.client.getQueryResults((GetQueryResultsRequest)((Object)GetQueryResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

