/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.internal;

import java.io.ByteArrayInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.sync.RequestBody;
import software.amazon.awssdk.http.SdkHttpMethod;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest;
import software.amazon.awssdk.utils.StringUtils;
import software.amazon.awssdk.utils.http.SdkHttpUtils;

@SdkInternalApi
public final class SwitchToPostInterceptor
implements ExecutionInterceptor {
    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        SdkHttpRequest httpRequest = context.httpRequest();
        if (context.request() instanceof SearchRequest) {
            return (SdkHttpRequest)((SdkHttpRequest.Builder)httpRequest.toBuilder()).clearQueryParameters().method(SdkHttpMethod.POST).build();
        }
        return context.httpRequest();
    }

    public Optional<RequestBody> modifyHttpContent(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        if (context.request() instanceof SearchRequest) {
            byte[] params = SdkHttpUtils.encodeAndFlattenFormData((Map)context.httpRequest().rawQueryParameters()).orElse("").getBytes(StandardCharsets.UTF_8);
            return Optional.of(RequestBody.fromContentProvider(() -> new ByteArrayInputStream(params), (long)params.length, (String)("application/x-www-form-urlencoded; charset=" + StringUtils.lowerCase((String)StandardCharsets.UTF_8.toString()))));
        }
        return context.requestBody();
    }
}

