/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatus;
import software.amazon.awssdk.services.cloudsearch.model.DomainStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeDomainsResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeDomainsResponse> {
    private static final SdkField<List<DomainStatus>> DOMAIN_STATUS_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DomainStatusList").getter(DescribeDomainsResponse.getter(DescribeDomainsResponse::domainStatusList)).setter(DescribeDomainsResponse.setter(Builder::domainStatusList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainStatusList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DomainStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_STATUS_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeDomainsResponse.memberNameToFieldInitializer();
    private final List<DomainStatus> domainStatusList;

    private DescribeDomainsResponse(BuilderImpl builder) {
        super(builder);
        this.domainStatusList = builder.domainStatusList;
    }

    public final boolean hasDomainStatusList() {
        return this.domainStatusList != null && !(this.domainStatusList instanceof SdkAutoConstructList);
    }

    public final List<DomainStatus> domainStatusList() {
        return this.domainStatusList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDomainStatusList() ? this.domainStatusList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDomainsResponse)) {
            return false;
        }
        DescribeDomainsResponse other = (DescribeDomainsResponse)((Object)obj);
        return this.hasDomainStatusList() == other.hasDomainStatusList() && Objects.equals(this.domainStatusList(), other.domainStatusList());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeDomainsResponse").add("DomainStatusList", this.hasDomainStatusList() ? this.domainStatusList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DomainStatusList": {
                return Optional.ofNullable(clazz.cast(this.domainStatusList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<DomainStatus>>> map = new HashMap<String, SdkField<List<DomainStatus>>>();
        map.put("DomainStatusList", DOMAIN_STATUS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeDomainsResponse, T> g) {
        return obj -> g.apply((DescribeDomainsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<DomainStatus> domainStatusList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDomainsResponse model) {
            super(model);
            this.domainStatusList(model.domainStatusList);
        }

        public final List<DomainStatus.Builder> getDomainStatusList() {
            List<DomainStatus.Builder> result = DomainStatusListCopier.copyToBuilder(this.domainStatusList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDomainStatusList(Collection<DomainStatus.BuilderImpl> domainStatusList) {
            this.domainStatusList = DomainStatusListCopier.copyFromBuilder(domainStatusList);
        }

        @Override
        public final Builder domainStatusList(Collection<DomainStatus> domainStatusList) {
            this.domainStatusList = DomainStatusListCopier.copy(domainStatusList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(DomainStatus ... domainStatusList) {
            this.domainStatusList(Arrays.asList(domainStatusList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder domainStatusList(Consumer<DomainStatus.Builder> ... domainStatusList) {
            this.domainStatusList(Stream.of(domainStatusList).map(c -> (DomainStatus)((DomainStatus.Builder)DomainStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeDomainsResponse build() {
            return new DescribeDomainsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeDomainsResponse> {
        public Builder domainStatusList(Collection<DomainStatus> var1);

        public Builder domainStatusList(DomainStatus ... var1);

        public Builder domainStatusList(Consumer<DomainStatus.Builder> ... var1);
    }
}

