/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.IndexFieldStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteIndexFieldResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DeleteIndexFieldResponse> {
    private static final SdkField<IndexFieldStatus> INDEX_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("IndexField").getter(DeleteIndexFieldResponse.getter(DeleteIndexFieldResponse::indexField)).setter(DeleteIndexFieldResponse.setter(Builder::indexField)).constructor(IndexFieldStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("IndexField", INDEX_FIELD_FIELD);
        }
    });
    private final IndexFieldStatus indexField;

    private DeleteIndexFieldResponse(BuilderImpl builder) {
        super(builder);
        this.indexField = builder.indexField;
    }

    public final IndexFieldStatus indexField() {
        return this.indexField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.indexField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteIndexFieldResponse)) {
            return false;
        }
        DeleteIndexFieldResponse other = (DeleteIndexFieldResponse)((Object)obj);
        return Objects.equals(this.indexField(), other.indexField());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteIndexFieldResponse").add("IndexField", (Object)this.indexField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "IndexField": {
                return Optional.ofNullable(clazz.cast(this.indexField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DeleteIndexFieldResponse, T> g) {
        return obj -> g.apply((DeleteIndexFieldResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private IndexFieldStatus indexField;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteIndexFieldResponse model) {
            super(model);
            this.indexField(model.indexField);
        }

        public final IndexFieldStatus.Builder getIndexField() {
            return this.indexField != null ? this.indexField.toBuilder() : null;
        }

        public final void setIndexField(IndexFieldStatus.BuilderImpl indexField) {
            this.indexField = indexField != null ? indexField.build() : null;
        }

        @Override
        public final Builder indexField(IndexFieldStatus indexField) {
            this.indexField = indexField;
            return this;
        }

        @Override
        public DeleteIndexFieldResponse build() {
            return new DeleteIndexFieldResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteIndexFieldResponse> {
        public Builder indexField(IndexFieldStatus var1);

        default public Builder indexField(Consumer<IndexFieldStatus.Builder> indexField) {
            return this.indexField((IndexFieldStatus)((IndexFieldStatus.Builder)IndexFieldStatus.builder().applyMutation(indexField)).build());
        }
    }
}

