/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParametersStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScalingParametersResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeScalingParametersResponse> {
    private static final SdkField<ScalingParametersStatus> SCALING_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScalingParameters").getter(DescribeScalingParametersResponse.getter(DescribeScalingParametersResponse::scalingParameters)).setter(DescribeScalingParametersResponse.setter(Builder::scalingParameters)).constructor(ScalingParametersStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScalingParameters").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALING_PARAMETERS_FIELD));
    private final ScalingParametersStatus scalingParameters;

    private DescribeScalingParametersResponse(BuilderImpl builder) {
        super(builder);
        this.scalingParameters = builder.scalingParameters;
    }

    public final ScalingParametersStatus scalingParameters() {
        return this.scalingParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.scalingParameters());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScalingParametersResponse)) {
            return false;
        }
        DescribeScalingParametersResponse other = (DescribeScalingParametersResponse)((Object)obj);
        return Objects.equals(this.scalingParameters(), other.scalingParameters());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScalingParametersResponse").add("ScalingParameters", (Object)this.scalingParameters()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScalingParameters": {
                return Optional.ofNullable(clazz.cast(this.scalingParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeScalingParametersResponse, T> g) {
        return obj -> g.apply((DescribeScalingParametersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private ScalingParametersStatus scalingParameters;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScalingParametersResponse model) {
            super(model);
            this.scalingParameters(model.scalingParameters);
        }

        public final ScalingParametersStatus.Builder getScalingParameters() {
            return this.scalingParameters != null ? this.scalingParameters.toBuilder() : null;
        }

        public final void setScalingParameters(ScalingParametersStatus.BuilderImpl scalingParameters) {
            this.scalingParameters = scalingParameters != null ? scalingParameters.build() : null;
        }

        @Override
        @Transient
        public final Builder scalingParameters(ScalingParametersStatus scalingParameters) {
            this.scalingParameters = scalingParameters;
            return this;
        }

        @Override
        public DescribeScalingParametersResponse build() {
            return new DescribeScalingParametersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScalingParametersResponse> {
        public Builder scalingParameters(ScalingParametersStatus var1);

        default public Builder scalingParameters(Consumer<ScalingParametersStatus.Builder> scalingParameters) {
            return this.scalingParameters((ScalingParametersStatus)((ScalingParametersStatus.Builder)ScalingParametersStatus.builder().applyMutation(scalingParameters)).build());
        }
    }
}

