/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration information for a field in the index, including its name, type, and options. The supported options
 * depend on the <code><a>IndexFieldType</a></code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IndexField implements SdkPojo, Serializable, ToCopyableBuilder<IndexField.Builder, IndexField> {
    private static final SdkField<String> INDEX_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IndexField::indexFieldName)).setter(setter(Builder::indexFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFieldName").build()).build();

    private static final SdkField<String> INDEX_FIELD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(IndexField::indexFieldTypeAsString)).setter(setter(Builder::indexFieldType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexFieldType").build()).build();

    private static final SdkField<IntOptions> INT_OPTIONS_FIELD = SdkField.<IntOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(IndexField::intOptions)).setter(setter(Builder::intOptions)).constructor(IntOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntOptions").build()).build();

    private static final SdkField<DoubleOptions> DOUBLE_OPTIONS_FIELD = SdkField
            .<DoubleOptions> builder(MarshallingType.SDK_POJO).getter(getter(IndexField::doubleOptions))
            .setter(setter(Builder::doubleOptions)).constructor(DoubleOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleOptions").build()).build();

    private static final SdkField<LiteralOptions> LITERAL_OPTIONS_FIELD = SdkField
            .<LiteralOptions> builder(MarshallingType.SDK_POJO).getter(getter(IndexField::literalOptions))
            .setter(setter(Builder::literalOptions)).constructor(LiteralOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiteralOptions").build()).build();

    private static final SdkField<TextOptions> TEXT_OPTIONS_FIELD = SdkField.<TextOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(IndexField::textOptions)).setter(setter(Builder::textOptions)).constructor(TextOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextOptions").build()).build();

    private static final SdkField<DateOptions> DATE_OPTIONS_FIELD = SdkField.<DateOptions> builder(MarshallingType.SDK_POJO)
            .getter(getter(IndexField::dateOptions)).setter(setter(Builder::dateOptions)).constructor(DateOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateOptions").build()).build();

    private static final SdkField<LatLonOptions> LAT_LON_OPTIONS_FIELD = SdkField
            .<LatLonOptions> builder(MarshallingType.SDK_POJO).getter(getter(IndexField::latLonOptions))
            .setter(setter(Builder::latLonOptions)).constructor(LatLonOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatLonOptions").build()).build();

    private static final SdkField<IntArrayOptions> INT_ARRAY_OPTIONS_FIELD = SdkField
            .<IntArrayOptions> builder(MarshallingType.SDK_POJO).getter(getter(IndexField::intArrayOptions))
            .setter(setter(Builder::intArrayOptions)).constructor(IntArrayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IntArrayOptions").build()).build();

    private static final SdkField<DoubleArrayOptions> DOUBLE_ARRAY_OPTIONS_FIELD = SdkField
            .<DoubleArrayOptions> builder(MarshallingType.SDK_POJO).getter(getter(IndexField::doubleArrayOptions))
            .setter(setter(Builder::doubleArrayOptions)).constructor(DoubleArrayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DoubleArrayOptions").build())
            .build();

    private static final SdkField<LiteralArrayOptions> LITERAL_ARRAY_OPTIONS_FIELD = SdkField
            .<LiteralArrayOptions> builder(MarshallingType.SDK_POJO).getter(getter(IndexField::literalArrayOptions))
            .setter(setter(Builder::literalArrayOptions)).constructor(LiteralArrayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LiteralArrayOptions").build())
            .build();

    private static final SdkField<TextArrayOptions> TEXT_ARRAY_OPTIONS_FIELD = SdkField
            .<TextArrayOptions> builder(MarshallingType.SDK_POJO).getter(getter(IndexField::textArrayOptions))
            .setter(setter(Builder::textArrayOptions)).constructor(TextArrayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextArrayOptions").build()).build();

    private static final SdkField<DateArrayOptions> DATE_ARRAY_OPTIONS_FIELD = SdkField
            .<DateArrayOptions> builder(MarshallingType.SDK_POJO).getter(getter(IndexField::dateArrayOptions))
            .setter(setter(Builder::dateArrayOptions)).constructor(DateArrayOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DateArrayOptions").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD_NAME_FIELD,
            INDEX_FIELD_TYPE_FIELD, INT_OPTIONS_FIELD, DOUBLE_OPTIONS_FIELD, LITERAL_OPTIONS_FIELD, TEXT_OPTIONS_FIELD,
            DATE_OPTIONS_FIELD, LAT_LON_OPTIONS_FIELD, INT_ARRAY_OPTIONS_FIELD, DOUBLE_ARRAY_OPTIONS_FIELD,
            LITERAL_ARRAY_OPTIONS_FIELD, TEXT_ARRAY_OPTIONS_FIELD, DATE_ARRAY_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String indexFieldName;

    private final String indexFieldType;

    private final IntOptions intOptions;

    private final DoubleOptions doubleOptions;

    private final LiteralOptions literalOptions;

    private final TextOptions textOptions;

    private final DateOptions dateOptions;

    private final LatLonOptions latLonOptions;

    private final IntArrayOptions intArrayOptions;

    private final DoubleArrayOptions doubleArrayOptions;

    private final LiteralArrayOptions literalArrayOptions;

    private final TextArrayOptions textArrayOptions;

    private final DateArrayOptions dateArrayOptions;

    private IndexField(BuilderImpl builder) {
        this.indexFieldName = builder.indexFieldName;
        this.indexFieldType = builder.indexFieldType;
        this.intOptions = builder.intOptions;
        this.doubleOptions = builder.doubleOptions;
        this.literalOptions = builder.literalOptions;
        this.textOptions = builder.textOptions;
        this.dateOptions = builder.dateOptions;
        this.latLonOptions = builder.latLonOptions;
        this.intArrayOptions = builder.intArrayOptions;
        this.doubleArrayOptions = builder.doubleArrayOptions;
        this.literalArrayOptions = builder.literalArrayOptions;
        this.textArrayOptions = builder.textArrayOptions;
        this.dateArrayOptions = builder.dateArrayOptions;
    }

    /**
     * <p>
     * A string that represents the name of an index field. CloudSearch supports regular index fields as well as dynamic
     * fields. A dynamic field's name defines a pattern that begins or ends with a wildcard. Any document fields that
     * don't map to a regular index field but do match a dynamic field's pattern are configured with the dynamic field's
     * indexing options.
     * </p>
     * <p>
     * Regular field names begin with a letter and can contain the following characters: a-z (lowercase), 0-9, and _
     * (underscore). Dynamic field names must begin or end with a wildcard (*). The wildcard can also be the only
     * character in a dynamic field name. Multiple wildcards, and wildcards embedded within a string are not supported.
     * </p>
     * <p>
     * The name <code>score</code> is reserved and cannot be used as a field name. To reference a document's ID, you can
     * use the name <code>_id</code>.
     * </p>
     * 
     * @return A string that represents the name of an index field. CloudSearch supports regular index fields as well as
     *         dynamic fields. A dynamic field's name defines a pattern that begins or ends with a wildcard. Any
     *         document fields that don't map to a regular index field but do match a dynamic field's pattern are
     *         configured with the dynamic field's indexing options. </p>
     *         <p>
     *         Regular field names begin with a letter and can contain the following characters: a-z (lowercase), 0-9,
     *         and _ (underscore). Dynamic field names must begin or end with a wildcard (*). The wildcard can also be
     *         the only character in a dynamic field name. Multiple wildcards, and wildcards embedded within a string
     *         are not supported.
     *         </p>
     *         <p>
     *         The name <code>score</code> is reserved and cannot be used as a field name. To reference a document's ID,
     *         you can use the name <code>_id</code>.
     */
    public String indexFieldName() {
        return indexFieldName;
    }

    /**
     * Returns the value of the IndexFieldType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexFieldType}
     * will return {@link IndexFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #indexFieldTypeAsString}.
     * </p>
     * 
     * @return The value of the IndexFieldType property for this object.
     * @see IndexFieldType
     */
    public IndexFieldType indexFieldType() {
        return IndexFieldType.fromValue(indexFieldType);
    }

    /**
     * Returns the value of the IndexFieldType property for this object.
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #indexFieldType}
     * will return {@link IndexFieldType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #indexFieldTypeAsString}.
     * </p>
     * 
     * @return The value of the IndexFieldType property for this object.
     * @see IndexFieldType
     */
    public String indexFieldTypeAsString() {
        return indexFieldType;
    }

    /**
     * Returns the value of the IntOptions property for this object.
     * 
     * @return The value of the IntOptions property for this object.
     */
    public IntOptions intOptions() {
        return intOptions;
    }

    /**
     * Returns the value of the DoubleOptions property for this object.
     * 
     * @return The value of the DoubleOptions property for this object.
     */
    public DoubleOptions doubleOptions() {
        return doubleOptions;
    }

    /**
     * Returns the value of the LiteralOptions property for this object.
     * 
     * @return The value of the LiteralOptions property for this object.
     */
    public LiteralOptions literalOptions() {
        return literalOptions;
    }

    /**
     * Returns the value of the TextOptions property for this object.
     * 
     * @return The value of the TextOptions property for this object.
     */
    public TextOptions textOptions() {
        return textOptions;
    }

    /**
     * Returns the value of the DateOptions property for this object.
     * 
     * @return The value of the DateOptions property for this object.
     */
    public DateOptions dateOptions() {
        return dateOptions;
    }

    /**
     * Returns the value of the LatLonOptions property for this object.
     * 
     * @return The value of the LatLonOptions property for this object.
     */
    public LatLonOptions latLonOptions() {
        return latLonOptions;
    }

    /**
     * Returns the value of the IntArrayOptions property for this object.
     * 
     * @return The value of the IntArrayOptions property for this object.
     */
    public IntArrayOptions intArrayOptions() {
        return intArrayOptions;
    }

    /**
     * Returns the value of the DoubleArrayOptions property for this object.
     * 
     * @return The value of the DoubleArrayOptions property for this object.
     */
    public DoubleArrayOptions doubleArrayOptions() {
        return doubleArrayOptions;
    }

    /**
     * Returns the value of the LiteralArrayOptions property for this object.
     * 
     * @return The value of the LiteralArrayOptions property for this object.
     */
    public LiteralArrayOptions literalArrayOptions() {
        return literalArrayOptions;
    }

    /**
     * Returns the value of the TextArrayOptions property for this object.
     * 
     * @return The value of the TextArrayOptions property for this object.
     */
    public TextArrayOptions textArrayOptions() {
        return textArrayOptions;
    }

    /**
     * Returns the value of the DateArrayOptions property for this object.
     * 
     * @return The value of the DateArrayOptions property for this object.
     */
    public DateArrayOptions dateArrayOptions() {
        return dateArrayOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(indexFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(indexFieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(intOptions());
        hashCode = 31 * hashCode + Objects.hashCode(doubleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(literalOptions());
        hashCode = 31 * hashCode + Objects.hashCode(textOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dateOptions());
        hashCode = 31 * hashCode + Objects.hashCode(latLonOptions());
        hashCode = 31 * hashCode + Objects.hashCode(intArrayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(doubleArrayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(literalArrayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(textArrayOptions());
        hashCode = 31 * hashCode + Objects.hashCode(dateArrayOptions());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IndexField)) {
            return false;
        }
        IndexField other = (IndexField) obj;
        return Objects.equals(indexFieldName(), other.indexFieldName())
                && Objects.equals(indexFieldTypeAsString(), other.indexFieldTypeAsString())
                && Objects.equals(intOptions(), other.intOptions()) && Objects.equals(doubleOptions(), other.doubleOptions())
                && Objects.equals(literalOptions(), other.literalOptions()) && Objects.equals(textOptions(), other.textOptions())
                && Objects.equals(dateOptions(), other.dateOptions()) && Objects.equals(latLonOptions(), other.latLonOptions())
                && Objects.equals(intArrayOptions(), other.intArrayOptions())
                && Objects.equals(doubleArrayOptions(), other.doubleArrayOptions())
                && Objects.equals(literalArrayOptions(), other.literalArrayOptions())
                && Objects.equals(textArrayOptions(), other.textArrayOptions())
                && Objects.equals(dateArrayOptions(), other.dateArrayOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("IndexField").add("IndexFieldName", indexFieldName())
                .add("IndexFieldType", indexFieldTypeAsString()).add("IntOptions", intOptions())
                .add("DoubleOptions", doubleOptions()).add("LiteralOptions", literalOptions()).add("TextOptions", textOptions())
                .add("DateOptions", dateOptions()).add("LatLonOptions", latLonOptions())
                .add("IntArrayOptions", intArrayOptions()).add("DoubleArrayOptions", doubleArrayOptions())
                .add("LiteralArrayOptions", literalArrayOptions()).add("TextArrayOptions", textArrayOptions())
                .add("DateArrayOptions", dateArrayOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IndexFieldName":
            return Optional.ofNullable(clazz.cast(indexFieldName()));
        case "IndexFieldType":
            return Optional.ofNullable(clazz.cast(indexFieldTypeAsString()));
        case "IntOptions":
            return Optional.ofNullable(clazz.cast(intOptions()));
        case "DoubleOptions":
            return Optional.ofNullable(clazz.cast(doubleOptions()));
        case "LiteralOptions":
            return Optional.ofNullable(clazz.cast(literalOptions()));
        case "TextOptions":
            return Optional.ofNullable(clazz.cast(textOptions()));
        case "DateOptions":
            return Optional.ofNullable(clazz.cast(dateOptions()));
        case "LatLonOptions":
            return Optional.ofNullable(clazz.cast(latLonOptions()));
        case "IntArrayOptions":
            return Optional.ofNullable(clazz.cast(intArrayOptions()));
        case "DoubleArrayOptions":
            return Optional.ofNullable(clazz.cast(doubleArrayOptions()));
        case "LiteralArrayOptions":
            return Optional.ofNullable(clazz.cast(literalArrayOptions()));
        case "TextArrayOptions":
            return Optional.ofNullable(clazz.cast(textArrayOptions()));
        case "DateArrayOptions":
            return Optional.ofNullable(clazz.cast(dateArrayOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IndexField, T> g) {
        return obj -> g.apply((IndexField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IndexField> {
        /**
         * <p>
         * A string that represents the name of an index field. CloudSearch supports regular index fields as well as
         * dynamic fields. A dynamic field's name defines a pattern that begins or ends with a wildcard. Any document
         * fields that don't map to a regular index field but do match a dynamic field's pattern are configured with the
         * dynamic field's indexing options.
         * </p>
         * <p>
         * Regular field names begin with a letter and can contain the following characters: a-z (lowercase), 0-9, and _
         * (underscore). Dynamic field names must begin or end with a wildcard (*). The wildcard can also be the only
         * character in a dynamic field name. Multiple wildcards, and wildcards embedded within a string are not
         * supported.
         * </p>
         * <p>
         * The name <code>score</code> is reserved and cannot be used as a field name. To reference a document's ID, you
         * can use the name <code>_id</code>.
         * </p>
         * 
         * @param indexFieldName
         *        A string that represents the name of an index field. CloudSearch supports regular index fields as well
         *        as dynamic fields. A dynamic field's name defines a pattern that begins or ends with a wildcard. Any
         *        document fields that don't map to a regular index field but do match a dynamic field's pattern are
         *        configured with the dynamic field's indexing options. </p>
         *        <p>
         *        Regular field names begin with a letter and can contain the following characters: a-z (lowercase),
         *        0-9, and _ (underscore). Dynamic field names must begin or end with a wildcard (*). The wildcard can
         *        also be the only character in a dynamic field name. Multiple wildcards, and wildcards embedded within
         *        a string are not supported.
         *        </p>
         *        <p>
         *        The name <code>score</code> is reserved and cannot be used as a field name. To reference a document's
         *        ID, you can use the name <code>_id</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder indexFieldName(String indexFieldName);

        /**
         * Sets the value of the IndexFieldType property for this object.
         *
         * @param indexFieldType
         *        The new value for the IndexFieldType property for this object.
         * @see IndexFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexFieldType
         */
        Builder indexFieldType(String indexFieldType);

        /**
         * Sets the value of the IndexFieldType property for this object.
         *
         * @param indexFieldType
         *        The new value for the IndexFieldType property for this object.
         * @see IndexFieldType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see IndexFieldType
         */
        Builder indexFieldType(IndexFieldType indexFieldType);

        /**
         * Sets the value of the IntOptions property for this object.
         *
         * @param intOptions
         *        The new value for the IntOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intOptions(IntOptions intOptions);

        /**
         * Sets the value of the IntOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link IntOptions.Builder} avoiding the need to create
         * one manually via {@link IntOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link IntOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #intOptions(IntOptions)}.
         * 
         * @param intOptions
         *        a consumer that will call methods on {@link IntOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intOptions(IntOptions)
         */
        default Builder intOptions(Consumer<IntOptions.Builder> intOptions) {
            return intOptions(IntOptions.builder().applyMutation(intOptions).build());
        }

        /**
         * Sets the value of the DoubleOptions property for this object.
         *
         * @param doubleOptions
         *        The new value for the DoubleOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleOptions(DoubleOptions doubleOptions);

        /**
         * Sets the value of the DoubleOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link DoubleOptions.Builder} avoiding the need to
         * create one manually via {@link DoubleOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DoubleOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #doubleOptions(DoubleOptions)}.
         * 
         * @param doubleOptions
         *        a consumer that will call methods on {@link DoubleOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #doubleOptions(DoubleOptions)
         */
        default Builder doubleOptions(Consumer<DoubleOptions.Builder> doubleOptions) {
            return doubleOptions(DoubleOptions.builder().applyMutation(doubleOptions).build());
        }

        /**
         * Sets the value of the LiteralOptions property for this object.
         *
         * @param literalOptions
         *        The new value for the LiteralOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder literalOptions(LiteralOptions literalOptions);

        /**
         * Sets the value of the LiteralOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link LiteralOptions.Builder} avoiding the need to
         * create one manually via {@link LiteralOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LiteralOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #literalOptions(LiteralOptions)}.
         * 
         * @param literalOptions
         *        a consumer that will call methods on {@link LiteralOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #literalOptions(LiteralOptions)
         */
        default Builder literalOptions(Consumer<LiteralOptions.Builder> literalOptions) {
            return literalOptions(LiteralOptions.builder().applyMutation(literalOptions).build());
        }

        /**
         * Sets the value of the TextOptions property for this object.
         *
         * @param textOptions
         *        The new value for the TextOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textOptions(TextOptions textOptions);

        /**
         * Sets the value of the TextOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link TextOptions.Builder} avoiding the need to create
         * one manually via {@link TextOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link TextOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #textOptions(TextOptions)}.
         * 
         * @param textOptions
         *        a consumer that will call methods on {@link TextOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textOptions(TextOptions)
         */
        default Builder textOptions(Consumer<TextOptions.Builder> textOptions) {
            return textOptions(TextOptions.builder().applyMutation(textOptions).build());
        }

        /**
         * Sets the value of the DateOptions property for this object.
         *
         * @param dateOptions
         *        The new value for the DateOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateOptions(DateOptions dateOptions);

        /**
         * Sets the value of the DateOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link DateOptions.Builder} avoiding the need to create
         * one manually via {@link DateOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateOptions.Builder#build()} is called immediately and its result
         * is passed to {@link #dateOptions(DateOptions)}.
         * 
         * @param dateOptions
         *        a consumer that will call methods on {@link DateOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateOptions(DateOptions)
         */
        default Builder dateOptions(Consumer<DateOptions.Builder> dateOptions) {
            return dateOptions(DateOptions.builder().applyMutation(dateOptions).build());
        }

        /**
         * Sets the value of the LatLonOptions property for this object.
         *
         * @param latLonOptions
         *        The new value for the LatLonOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latLonOptions(LatLonOptions latLonOptions);

        /**
         * Sets the value of the LatLonOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link LatLonOptions.Builder} avoiding the need to
         * create one manually via {@link LatLonOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LatLonOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #latLonOptions(LatLonOptions)}.
         * 
         * @param latLonOptions
         *        a consumer that will call methods on {@link LatLonOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latLonOptions(LatLonOptions)
         */
        default Builder latLonOptions(Consumer<LatLonOptions.Builder> latLonOptions) {
            return latLonOptions(LatLonOptions.builder().applyMutation(latLonOptions).build());
        }

        /**
         * Sets the value of the IntArrayOptions property for this object.
         *
         * @param intArrayOptions
         *        The new value for the IntArrayOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder intArrayOptions(IntArrayOptions intArrayOptions);

        /**
         * Sets the value of the IntArrayOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link IntArrayOptions.Builder} avoiding the need to
         * create one manually via {@link IntArrayOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link IntArrayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #intArrayOptions(IntArrayOptions)}.
         * 
         * @param intArrayOptions
         *        a consumer that will call methods on {@link IntArrayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #intArrayOptions(IntArrayOptions)
         */
        default Builder intArrayOptions(Consumer<IntArrayOptions.Builder> intArrayOptions) {
            return intArrayOptions(IntArrayOptions.builder().applyMutation(intArrayOptions).build());
        }

        /**
         * Sets the value of the DoubleArrayOptions property for this object.
         *
         * @param doubleArrayOptions
         *        The new value for the DoubleArrayOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder doubleArrayOptions(DoubleArrayOptions doubleArrayOptions);

        /**
         * Sets the value of the DoubleArrayOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link DoubleArrayOptions.Builder} avoiding the need to
         * create one manually via {@link DoubleArrayOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DoubleArrayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #doubleArrayOptions(DoubleArrayOptions)}.
         * 
         * @param doubleArrayOptions
         *        a consumer that will call methods on {@link DoubleArrayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #doubleArrayOptions(DoubleArrayOptions)
         */
        default Builder doubleArrayOptions(Consumer<DoubleArrayOptions.Builder> doubleArrayOptions) {
            return doubleArrayOptions(DoubleArrayOptions.builder().applyMutation(doubleArrayOptions).build());
        }

        /**
         * Sets the value of the LiteralArrayOptions property for this object.
         *
         * @param literalArrayOptions
         *        The new value for the LiteralArrayOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder literalArrayOptions(LiteralArrayOptions literalArrayOptions);

        /**
         * Sets the value of the LiteralArrayOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link LiteralArrayOptions.Builder} avoiding the need
         * to create one manually via {@link LiteralArrayOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link LiteralArrayOptions.Builder#build()} is called immediately and
         * its result is passed to {@link #literalArrayOptions(LiteralArrayOptions)}.
         * 
         * @param literalArrayOptions
         *        a consumer that will call methods on {@link LiteralArrayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #literalArrayOptions(LiteralArrayOptions)
         */
        default Builder literalArrayOptions(Consumer<LiteralArrayOptions.Builder> literalArrayOptions) {
            return literalArrayOptions(LiteralArrayOptions.builder().applyMutation(literalArrayOptions).build());
        }

        /**
         * Sets the value of the TextArrayOptions property for this object.
         *
         * @param textArrayOptions
         *        The new value for the TextArrayOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textArrayOptions(TextArrayOptions textArrayOptions);

        /**
         * Sets the value of the TextArrayOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link TextArrayOptions.Builder} avoiding the need to
         * create one manually via {@link TextArrayOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link TextArrayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #textArrayOptions(TextArrayOptions)}.
         * 
         * @param textArrayOptions
         *        a consumer that will call methods on {@link TextArrayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textArrayOptions(TextArrayOptions)
         */
        default Builder textArrayOptions(Consumer<TextArrayOptions.Builder> textArrayOptions) {
            return textArrayOptions(TextArrayOptions.builder().applyMutation(textArrayOptions).build());
        }

        /**
         * Sets the value of the DateArrayOptions property for this object.
         *
         * @param dateArrayOptions
         *        The new value for the DateArrayOptions property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dateArrayOptions(DateArrayOptions dateArrayOptions);

        /**
         * Sets the value of the DateArrayOptions property for this object.
         *
         * This is a convenience that creates an instance of the {@link DateArrayOptions.Builder} avoiding the need to
         * create one manually via {@link DateArrayOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DateArrayOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #dateArrayOptions(DateArrayOptions)}.
         * 
         * @param dateArrayOptions
         *        a consumer that will call methods on {@link DateArrayOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dateArrayOptions(DateArrayOptions)
         */
        default Builder dateArrayOptions(Consumer<DateArrayOptions.Builder> dateArrayOptions) {
            return dateArrayOptions(DateArrayOptions.builder().applyMutation(dateArrayOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String indexFieldName;

        private String indexFieldType;

        private IntOptions intOptions;

        private DoubleOptions doubleOptions;

        private LiteralOptions literalOptions;

        private TextOptions textOptions;

        private DateOptions dateOptions;

        private LatLonOptions latLonOptions;

        private IntArrayOptions intArrayOptions;

        private DoubleArrayOptions doubleArrayOptions;

        private LiteralArrayOptions literalArrayOptions;

        private TextArrayOptions textArrayOptions;

        private DateArrayOptions dateArrayOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(IndexField model) {
            indexFieldName(model.indexFieldName);
            indexFieldType(model.indexFieldType);
            intOptions(model.intOptions);
            doubleOptions(model.doubleOptions);
            literalOptions(model.literalOptions);
            textOptions(model.textOptions);
            dateOptions(model.dateOptions);
            latLonOptions(model.latLonOptions);
            intArrayOptions(model.intArrayOptions);
            doubleArrayOptions(model.doubleArrayOptions);
            literalArrayOptions(model.literalArrayOptions);
            textArrayOptions(model.textArrayOptions);
            dateArrayOptions(model.dateArrayOptions);
        }

        public final String getIndexFieldName() {
            return indexFieldName;
        }

        @Override
        public final Builder indexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
            return this;
        }

        public final void setIndexFieldName(String indexFieldName) {
            this.indexFieldName = indexFieldName;
        }

        public final String getIndexFieldType() {
            return indexFieldType;
        }

        @Override
        public final Builder indexFieldType(String indexFieldType) {
            this.indexFieldType = indexFieldType;
            return this;
        }

        @Override
        public final Builder indexFieldType(IndexFieldType indexFieldType) {
            this.indexFieldType(indexFieldType == null ? null : indexFieldType.toString());
            return this;
        }

        public final void setIndexFieldType(String indexFieldType) {
            this.indexFieldType = indexFieldType;
        }

        public final IntOptions.Builder getIntOptions() {
            return intOptions != null ? intOptions.toBuilder() : null;
        }

        @Override
        public final Builder intOptions(IntOptions intOptions) {
            this.intOptions = intOptions;
            return this;
        }

        public final void setIntOptions(IntOptions.BuilderImpl intOptions) {
            this.intOptions = intOptions != null ? intOptions.build() : null;
        }

        public final DoubleOptions.Builder getDoubleOptions() {
            return doubleOptions != null ? doubleOptions.toBuilder() : null;
        }

        @Override
        public final Builder doubleOptions(DoubleOptions doubleOptions) {
            this.doubleOptions = doubleOptions;
            return this;
        }

        public final void setDoubleOptions(DoubleOptions.BuilderImpl doubleOptions) {
            this.doubleOptions = doubleOptions != null ? doubleOptions.build() : null;
        }

        public final LiteralOptions.Builder getLiteralOptions() {
            return literalOptions != null ? literalOptions.toBuilder() : null;
        }

        @Override
        public final Builder literalOptions(LiteralOptions literalOptions) {
            this.literalOptions = literalOptions;
            return this;
        }

        public final void setLiteralOptions(LiteralOptions.BuilderImpl literalOptions) {
            this.literalOptions = literalOptions != null ? literalOptions.build() : null;
        }

        public final TextOptions.Builder getTextOptions() {
            return textOptions != null ? textOptions.toBuilder() : null;
        }

        @Override
        public final Builder textOptions(TextOptions textOptions) {
            this.textOptions = textOptions;
            return this;
        }

        public final void setTextOptions(TextOptions.BuilderImpl textOptions) {
            this.textOptions = textOptions != null ? textOptions.build() : null;
        }

        public final DateOptions.Builder getDateOptions() {
            return dateOptions != null ? dateOptions.toBuilder() : null;
        }

        @Override
        public final Builder dateOptions(DateOptions dateOptions) {
            this.dateOptions = dateOptions;
            return this;
        }

        public final void setDateOptions(DateOptions.BuilderImpl dateOptions) {
            this.dateOptions = dateOptions != null ? dateOptions.build() : null;
        }

        public final LatLonOptions.Builder getLatLonOptions() {
            return latLonOptions != null ? latLonOptions.toBuilder() : null;
        }

        @Override
        public final Builder latLonOptions(LatLonOptions latLonOptions) {
            this.latLonOptions = latLonOptions;
            return this;
        }

        public final void setLatLonOptions(LatLonOptions.BuilderImpl latLonOptions) {
            this.latLonOptions = latLonOptions != null ? latLonOptions.build() : null;
        }

        public final IntArrayOptions.Builder getIntArrayOptions() {
            return intArrayOptions != null ? intArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder intArrayOptions(IntArrayOptions intArrayOptions) {
            this.intArrayOptions = intArrayOptions;
            return this;
        }

        public final void setIntArrayOptions(IntArrayOptions.BuilderImpl intArrayOptions) {
            this.intArrayOptions = intArrayOptions != null ? intArrayOptions.build() : null;
        }

        public final DoubleArrayOptions.Builder getDoubleArrayOptions() {
            return doubleArrayOptions != null ? doubleArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder doubleArrayOptions(DoubleArrayOptions doubleArrayOptions) {
            this.doubleArrayOptions = doubleArrayOptions;
            return this;
        }

        public final void setDoubleArrayOptions(DoubleArrayOptions.BuilderImpl doubleArrayOptions) {
            this.doubleArrayOptions = doubleArrayOptions != null ? doubleArrayOptions.build() : null;
        }

        public final LiteralArrayOptions.Builder getLiteralArrayOptions() {
            return literalArrayOptions != null ? literalArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder literalArrayOptions(LiteralArrayOptions literalArrayOptions) {
            this.literalArrayOptions = literalArrayOptions;
            return this;
        }

        public final void setLiteralArrayOptions(LiteralArrayOptions.BuilderImpl literalArrayOptions) {
            this.literalArrayOptions = literalArrayOptions != null ? literalArrayOptions.build() : null;
        }

        public final TextArrayOptions.Builder getTextArrayOptions() {
            return textArrayOptions != null ? textArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder textArrayOptions(TextArrayOptions textArrayOptions) {
            this.textArrayOptions = textArrayOptions;
            return this;
        }

        public final void setTextArrayOptions(TextArrayOptions.BuilderImpl textArrayOptions) {
            this.textArrayOptions = textArrayOptions != null ? textArrayOptions.build() : null;
        }

        public final DateArrayOptions.Builder getDateArrayOptions() {
            return dateArrayOptions != null ? dateArrayOptions.toBuilder() : null;
        }

        @Override
        public final Builder dateArrayOptions(DateArrayOptions dateArrayOptions) {
            this.dateArrayOptions = dateArrayOptions;
            return this;
        }

        public final void setDateArrayOptions(DateArrayOptions.BuilderImpl dateArrayOptions) {
            this.dateArrayOptions = dateArrayOptions != null ? dateArrayOptions.build() : null;
        }

        @Override
        public IndexField build() {
            return new IndexField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
