/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Container for the parameters to the <code><a>DescribeSuggester</a></code> operation. Specifies the name of the domain
 * you want to describe. To restrict the response to particular suggesters, specify the names of the suggesters you want
 * to describe. To show the active configuration and exclude any pending changes, set the <code>Deployed</code> option
 * to <code>true</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeSuggestersRequest extends CloudSearchRequest implements
        ToCopyableBuilder<DescribeSuggestersRequest.Builder, DescribeSuggestersRequest> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(DescribeSuggestersRequest::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainName").build()).build();

    private static final SdkField<List<String>> SUGGESTER_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(DescribeSuggestersRequest::suggesterNames))
            .setter(setter(Builder::suggesterNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SuggesterNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> DEPLOYED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(DescribeSuggestersRequest::deployed)).setter(setter(Builder::deployed))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Deployed").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            SUGGESTER_NAMES_FIELD, DEPLOYED_FIELD));

    private final String domainName;

    private final List<String> suggesterNames;

    private final Boolean deployed;

    private DescribeSuggestersRequest(BuilderImpl builder) {
        super(builder);
        this.domainName = builder.domainName;
        this.suggesterNames = builder.suggesterNames;
        this.deployed = builder.deployed;
    }

    /**
     * <p>
     * The name of the domain you want to describe.
     * </p>
     * 
     * @return The name of the domain you want to describe.
     */
    public String domainName() {
        return domainName;
    }

    /**
     * Returns true if the SuggesterNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasSuggesterNames() {
        return suggesterNames != null && !(suggesterNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The suggesters you want to describe.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasSuggesterNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The suggesters you want to describe.
     */
    public List<String> suggesterNames() {
        return suggesterNames;
    }

    /**
     * <p>
     * Whether to display the deployed configuration (<code>true</code>) or include any pending changes (
     * <code>false</code>). Defaults to <code>false</code>.
     * </p>
     * 
     * @return Whether to display the deployed configuration (<code>true</code>) or include any pending changes (
     *         <code>false</code>). Defaults to <code>false</code>.
     */
    public Boolean deployed() {
        return deployed;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(suggesterNames());
        hashCode = 31 * hashCode + Objects.hashCode(deployed());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSuggestersRequest)) {
            return false;
        }
        DescribeSuggestersRequest other = (DescribeSuggestersRequest) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(suggesterNames(), other.suggesterNames())
                && Objects.equals(deployed(), other.deployed());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeSuggestersRequest").add("DomainName", domainName())
                .add("SuggesterNames", suggesterNames()).add("Deployed", deployed()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "SuggesterNames":
            return Optional.ofNullable(clazz.cast(suggesterNames()));
        case "Deployed":
            return Optional.ofNullable(clazz.cast(deployed()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSuggestersRequest, T> g) {
        return obj -> g.apply((DescribeSuggestersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchRequest.Builder, SdkPojo, CopyableBuilder<Builder, DescribeSuggestersRequest> {
        /**
         * <p>
         * The name of the domain you want to describe.
         * </p>
         * 
         * @param domainName
         *        The name of the domain you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The suggesters you want to describe.
         * </p>
         * 
         * @param suggesterNames
         *        The suggesters you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggesterNames(Collection<String> suggesterNames);

        /**
         * <p>
         * The suggesters you want to describe.
         * </p>
         * 
         * @param suggesterNames
         *        The suggesters you want to describe.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder suggesterNames(String... suggesterNames);

        /**
         * <p>
         * Whether to display the deployed configuration (<code>true</code>) or include any pending changes (
         * <code>false</code>). Defaults to <code>false</code>.
         * </p>
         * 
         * @param deployed
         *        Whether to display the deployed configuration (<code>true</code>) or include any pending changes (
         *        <code>false</code>). Defaults to <code>false</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployed(Boolean deployed);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends CloudSearchRequest.BuilderImpl implements Builder {
        private String domainName;

        private List<String> suggesterNames = DefaultSdkAutoConstructList.getInstance();

        private Boolean deployed;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSuggestersRequest model) {
            super(model);
            domainName(model.domainName);
            suggesterNames(model.suggesterNames);
            deployed(model.deployed);
        }

        public final String getDomainName() {
            return domainName;
        }

        @Override
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        public final Collection<String> getSuggesterNames() {
            return suggesterNames;
        }

        @Override
        public final Builder suggesterNames(Collection<String> suggesterNames) {
            this.suggesterNames = StandardNameListCopier.copy(suggesterNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggesterNames(String... suggesterNames) {
            suggesterNames(Arrays.asList(suggesterNames));
            return this;
        }

        public final void setSuggesterNames(Collection<String> suggesterNames) {
            this.suggesterNames = StandardNameListCopier.copy(suggesterNames);
        }

        public final Boolean getDeployed() {
            return deployed;
        }

        @Override
        public final Builder deployed(Boolean deployed) {
            this.deployed = deployed;
            return this;
        }

        public final void setDeployed(Boolean deployed) {
            this.deployed = deployed;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DescribeSuggestersRequest build() {
            return new DescribeSuggestersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
