/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>DescribeAnalysisSchemes</code> request. Contains the analysis schemes configured for the domain
 * specified in the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnalysisSchemesResponse extends CloudSearchResponse implements
        ToCopyableBuilder<DescribeAnalysisSchemesResponse.Builder, DescribeAnalysisSchemesResponse> {
    private static final SdkField<List<AnalysisSchemeStatus>> ANALYSIS_SCHEMES_FIELD = SdkField
            .<List<AnalysisSchemeStatus>> builder(MarshallingType.LIST)
            .getter(getter(DescribeAnalysisSchemesResponse::analysisSchemes))
            .setter(setter(Builder::analysisSchemes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AnalysisSchemes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AnalysisSchemeStatus> builder(MarshallingType.SDK_POJO)
                                            .constructor(AnalysisSchemeStatus::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_SCHEMES_FIELD));

    private final List<AnalysisSchemeStatus> analysisSchemes;

    private DescribeAnalysisSchemesResponse(BuilderImpl builder) {
        super(builder);
        this.analysisSchemes = builder.analysisSchemes;
    }

    /**
     * Returns true if the AnalysisSchemes property was specified by the sender (it may be empty), or false if the
     * sender did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS
     * service.
     */
    public boolean hasAnalysisSchemes() {
        return analysisSchemes != null && !(analysisSchemes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The analysis scheme descriptions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasAnalysisSchemes()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The analysis scheme descriptions.
     */
    public List<AnalysisSchemeStatus> analysisSchemes() {
        return analysisSchemes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysisSchemes());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnalysisSchemesResponse)) {
            return false;
        }
        DescribeAnalysisSchemesResponse other = (DescribeAnalysisSchemesResponse) obj;
        return Objects.equals(analysisSchemes(), other.analysisSchemes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("DescribeAnalysisSchemesResponse").add("AnalysisSchemes", analysisSchemes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AnalysisSchemes":
            return Optional.ofNullable(clazz.cast(analysisSchemes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnalysisSchemesResponse, T> g) {
        return obj -> g.apply((DescribeAnalysisSchemesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAnalysisSchemesResponse> {
        /**
         * <p>
         * The analysis scheme descriptions.
         * </p>
         * 
         * @param analysisSchemes
         *        The analysis scheme descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisSchemes(Collection<AnalysisSchemeStatus> analysisSchemes);

        /**
         * <p>
         * The analysis scheme descriptions.
         * </p>
         * 
         * @param analysisSchemes
         *        The analysis scheme descriptions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysisSchemes(AnalysisSchemeStatus... analysisSchemes);

        /**
         * <p>
         * The analysis scheme descriptions.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AnalysisSchemeStatus>.Builder} avoiding the
         * need to create one manually via {@link List<AnalysisSchemeStatus>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AnalysisSchemeStatus>.Builder#build()} is called immediately
         * and its result is passed to {@link #analysisSchemes(List<AnalysisSchemeStatus>)}.
         * 
         * @param analysisSchemes
         *        a consumer that will call methods on {@link List<AnalysisSchemeStatus>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysisSchemes(List<AnalysisSchemeStatus>)
         */
        Builder analysisSchemes(Consumer<AnalysisSchemeStatus.Builder>... analysisSchemes);
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private List<AnalysisSchemeStatus> analysisSchemes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnalysisSchemesResponse model) {
            super(model);
            analysisSchemes(model.analysisSchemes);
        }

        public final Collection<AnalysisSchemeStatus.Builder> getAnalysisSchemes() {
            return analysisSchemes != null ? analysisSchemes.stream().map(AnalysisSchemeStatus::toBuilder)
                    .collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder analysisSchemes(Collection<AnalysisSchemeStatus> analysisSchemes) {
            this.analysisSchemes = AnalysisSchemeStatusListCopier.copy(analysisSchemes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSchemes(AnalysisSchemeStatus... analysisSchemes) {
            analysisSchemes(Arrays.asList(analysisSchemes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder analysisSchemes(Consumer<AnalysisSchemeStatus.Builder>... analysisSchemes) {
            analysisSchemes(Stream.of(analysisSchemes).map(c -> AnalysisSchemeStatus.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setAnalysisSchemes(Collection<AnalysisSchemeStatus.BuilderImpl> analysisSchemes) {
            this.analysisSchemes = AnalysisSchemeStatusListCopier.copyFromBuilder(analysisSchemes);
        }

        @Override
        public DescribeAnalysisSchemesResponse build() {
            return new DescribeAnalysisSchemesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
