/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Synonyms, stopwords, and stemming options for an analysis scheme. Includes tokenization dictionary for Japanese.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnalysisOptions implements SdkPojo, Serializable, ToCopyableBuilder<AnalysisOptions.Builder, AnalysisOptions> {
    private static final SdkField<String> SYNONYMS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisOptions::synonyms)).setter(setter(Builder::synonyms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Synonyms").build()).build();

    private static final SdkField<String> STOPWORDS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisOptions::stopwords)).setter(setter(Builder::stopwords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Stopwords").build()).build();

    private static final SdkField<String> STEMMING_DICTIONARY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisOptions::stemmingDictionary)).setter(setter(Builder::stemmingDictionary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StemmingDictionary").build())
            .build();

    private static final SdkField<String> JAPANESE_TOKENIZATION_DICTIONARY_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisOptions::japaneseTokenizationDictionary))
            .setter(setter(Builder::japaneseTokenizationDictionary))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JapaneseTokenizationDictionary")
                    .build()).build();

    private static final SdkField<String> ALGORITHMIC_STEMMING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(AnalysisOptions::algorithmicStemmingAsString)).setter(setter(Builder::algorithmicStemming))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AlgorithmicStemming").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SYNONYMS_FIELD,
            STOPWORDS_FIELD, STEMMING_DICTIONARY_FIELD, JAPANESE_TOKENIZATION_DICTIONARY_FIELD, ALGORITHMIC_STEMMING_FIELD));

    private static final long serialVersionUID = 1L;

    private final String synonyms;

    private final String stopwords;

    private final String stemmingDictionary;

    private final String japaneseTokenizationDictionary;

    private final String algorithmicStemming;

    private AnalysisOptions(BuilderImpl builder) {
        this.synonyms = builder.synonyms;
        this.stopwords = builder.stopwords;
        this.stemmingDictionary = builder.stemmingDictionary;
        this.japaneseTokenizationDictionary = builder.japaneseTokenizationDictionary;
        this.algorithmicStemming = builder.algorithmicStemming;
    }

    /**
     * <p>
     * A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each
     * sub-array is a group of terms where each term in the group is considered a synonym of every other term in the
     * group. The aliases value is an object that contains a collection of string:value pairs where the string specifies
     * a term and the array of values specifies each of the aliases for that term. An alias is considered a synonym of
     * the specified term, but the term is not considered a synonym of the alias. For more information about specifying
     * synonyms, see <a
     * href="http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms"
     * >Synonyms</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     * </p>
     * 
     * @return A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each
     *         sub-array is a group of terms where each term in the group is considered a synonym of every other term in
     *         the group. The aliases value is an object that contains a collection of string:value pairs where the
     *         string specifies a term and the array of values specifies each of the aliases for that term. An alias is
     *         considered a synonym of the specified term, but the term is not considered a synonym of the alias. For
     *         more information about specifying synonyms, see <a href=
     *         "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms"
     *         >Synonyms</a> in the <i>Amazon CloudSearch Developer Guide</i>.
     */
    public String synonyms() {
        return synonyms;
    }

    /**
     * <p>
     * A JSON array of terms to ignore during indexing and searching. For example, <code>["a", "an", "the", "of"]</code>
     * . The stopwords dictionary must explicitly list each word you want to ignore. Wildcards and regular expressions
     * are not supported.
     * </p>
     * 
     * @return A JSON array of terms to ignore during indexing and searching. For example,
     *         <code>["a", "an", "the", "of"]</code>. The stopwords dictionary must explicitly list each word you want
     *         to ignore. Wildcards and regular expressions are not supported.
     */
    public String stopwords() {
        return stopwords;
    }

    /**
     * <p>
     * A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example,
     * <code>{"term1": "stem1", "term2": "stem2", "term3": "stem3"}</code>. The stemming dictionary is applied in
     * addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to
     * correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.
     * </p>
     * 
     * @return A JSON object that contains a collection of string:value pairs that each map a term to its stem. For
     *         example, <code>{"term1": "stem1", "term2": "stem2", "term3": "stem3"}</code>. The stemming dictionary is
     *         applied in addition to any algorithmic stemming. This enables you to override the results of the
     *         algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a
     *         stemming dictionary is 500 KB.
     */
    public String stemmingDictionary() {
        return stemmingDictionary;
    }

    /**
     * <p>
     * A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese Tokenizaiton.
     * The Japanese tokenization dictionary enables you to override the default tokenization for selected terms. This is
     * only valid for Japanese language fields.
     * </p>
     * 
     * @return A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese
     *         Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for
     *         selected terms. This is only valid for Japanese language fields.
     */
    public String japaneseTokenizationDictionary() {
        return japaneseTokenizationDictionary;
    }

    /**
     * <p>
     * The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>, or
     * <code>full</code>. The available levels vary depending on the language. For more information, see <a href=
     * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
     * target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer Guide</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #algorithmicStemming} will return {@link AlgorithmicStemming#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #algorithmicStemmingAsString}.
     * </p>
     * 
     * @return The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>
     *         , or <code>full</code>. The available levels vary depending on the language. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
     *         target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer
     *         Guide</i>
     * @see AlgorithmicStemming
     */
    public AlgorithmicStemming algorithmicStemming() {
        return AlgorithmicStemming.fromValue(algorithmicStemming);
    }

    /**
     * <p>
     * The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>, or
     * <code>full</code>. The available levels vary depending on the language. For more information, see <a href=
     * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
     * target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer Guide</i>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #algorithmicStemming} will return {@link AlgorithmicStemming#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #algorithmicStemmingAsString}.
     * </p>
     * 
     * @return The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>
     *         , or <code>full</code>. The available levels vary depending on the language. For more information, see <a
     *         href=
     *         "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
     *         target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer
     *         Guide</i>
     * @see AlgorithmicStemming
     */
    public String algorithmicStemmingAsString() {
        return algorithmicStemming;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(synonyms());
        hashCode = 31 * hashCode + Objects.hashCode(stopwords());
        hashCode = 31 * hashCode + Objects.hashCode(stemmingDictionary());
        hashCode = 31 * hashCode + Objects.hashCode(japaneseTokenizationDictionary());
        hashCode = 31 * hashCode + Objects.hashCode(algorithmicStemmingAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisOptions)) {
            return false;
        }
        AnalysisOptions other = (AnalysisOptions) obj;
        return Objects.equals(synonyms(), other.synonyms()) && Objects.equals(stopwords(), other.stopwords())
                && Objects.equals(stemmingDictionary(), other.stemmingDictionary())
                && Objects.equals(japaneseTokenizationDictionary(), other.japaneseTokenizationDictionary())
                && Objects.equals(algorithmicStemmingAsString(), other.algorithmicStemmingAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("AnalysisOptions").add("Synonyms", synonyms()).add("Stopwords", stopwords())
                .add("StemmingDictionary", stemmingDictionary())
                .add("JapaneseTokenizationDictionary", japaneseTokenizationDictionary())
                .add("AlgorithmicStemming", algorithmicStemmingAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Synonyms":
            return Optional.ofNullable(clazz.cast(synonyms()));
        case "Stopwords":
            return Optional.ofNullable(clazz.cast(stopwords()));
        case "StemmingDictionary":
            return Optional.ofNullable(clazz.cast(stemmingDictionary()));
        case "JapaneseTokenizationDictionary":
            return Optional.ofNullable(clazz.cast(japaneseTokenizationDictionary()));
        case "AlgorithmicStemming":
            return Optional.ofNullable(clazz.cast(algorithmicStemmingAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnalysisOptions, T> g) {
        return obj -> g.apply((AnalysisOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnalysisOptions> {
        /**
         * <p>
         * A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where each
         * sub-array is a group of terms where each term in the group is considered a synonym of every other term in the
         * group. The aliases value is an object that contains a collection of string:value pairs where the string
         * specifies a term and the array of values specifies each of the aliases for that term. An alias is considered
         * a synonym of the specified term, but the term is not considered a synonym of the alias. For more information
         * about specifying synonyms, see <a href=
         * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms"
         * >Synonyms</a> in the <i>Amazon CloudSearch Developer Guide</i>.
         * </p>
         * 
         * @param synonyms
         *        A JSON object that defines synonym groups and aliases. A synonym group is an array of arrays, where
         *        each sub-array is a group of terms where each term in the group is considered a synonym of every other
         *        term in the group. The aliases value is an object that contains a collection of string:value pairs
         *        where the string specifies a term and the array of values specifies each of the aliases for that term.
         *        An alias is considered a synonym of the specified term, but the term is not considered a synonym of
         *        the alias. For more information about specifying synonyms, see <a href=
         *        "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/configuring-analysis-schemes.html#synonyms"
         *        >Synonyms</a> in the <i>Amazon CloudSearch Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder synonyms(String synonyms);

        /**
         * <p>
         * A JSON array of terms to ignore during indexing and searching. For example,
         * <code>["a", "an", "the", "of"]</code>. The stopwords dictionary must explicitly list each word you want to
         * ignore. Wildcards and regular expressions are not supported.
         * </p>
         * 
         * @param stopwords
         *        A JSON array of terms to ignore during indexing and searching. For example,
         *        <code>["a", "an", "the", "of"]</code>. The stopwords dictionary must explicitly list each word you
         *        want to ignore. Wildcards and regular expressions are not supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stopwords(String stopwords);

        /**
         * <p>
         * A JSON object that contains a collection of string:value pairs that each map a term to its stem. For example,
         * <code>{"term1": "stem1", "term2": "stem2", "term3": "stem3"}</code>. The stemming dictionary is applied in
         * addition to any algorithmic stemming. This enables you to override the results of the algorithmic stemming to
         * correct specific cases of overstemming or understemming. The maximum size of a stemming dictionary is 500 KB.
         * </p>
         * 
         * @param stemmingDictionary
         *        A JSON object that contains a collection of string:value pairs that each map a term to its stem. For
         *        example, <code>{"term1": "stem1", "term2": "stem2", "term3": "stem3"}</code>. The stemming dictionary
         *        is applied in addition to any algorithmic stemming. This enables you to override the results of the
         *        algorithmic stemming to correct specific cases of overstemming or understemming. The maximum size of a
         *        stemming dictionary is 500 KB.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stemmingDictionary(String stemmingDictionary);

        /**
         * <p>
         * A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese
         * Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization for
         * selected terms. This is only valid for Japanese language fields.
         * </p>
         * 
         * @param japaneseTokenizationDictionary
         *        A JSON array that contains a collection of terms, tokens, readings and part of speech for Japanese
         *        Tokenizaiton. The Japanese tokenization dictionary enables you to override the default tokenization
         *        for selected terms. This is only valid for Japanese language fields.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder japaneseTokenizationDictionary(String japaneseTokenizationDictionary);

        /**
         * <p>
         * The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>, or
         * <code>full</code>. The available levels vary depending on the language. For more information, see <a href=
         * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
         * target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer
         * Guide</i>
         * </p>
         * 
         * @param algorithmicStemming
         *        The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>,
         *        <code>light</code>, or <code>full</code>. The available levels vary depending on the language. For
         *        more information, see <a href=
         *        "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
         *        target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer
         *        Guide</i>
         * @see AlgorithmicStemming
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmicStemming
         */
        Builder algorithmicStemming(String algorithmicStemming);

        /**
         * <p>
         * The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>, <code>light</code>, or
         * <code>full</code>. The available levels vary depending on the language. For more information, see <a href=
         * "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
         * target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer
         * Guide</i>
         * </p>
         * 
         * @param algorithmicStemming
         *        The level of algorithmic stemming to perform: <code>none</code>, <code>minimal</code>,
         *        <code>light</code>, or <code>full</code>. The available levels vary depending on the language. For
         *        more information, see <a href=
         *        "http://docs.aws.amazon.com/cloudsearch/latest/developerguide/text-processing.html#text-processing-settings"
         *        target="_blank">Language Specific Text Processing Settings</a> in the <i>Amazon CloudSearch Developer
         *        Guide</i>
         * @see AlgorithmicStemming
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlgorithmicStemming
         */
        Builder algorithmicStemming(AlgorithmicStemming algorithmicStemming);
    }

    static final class BuilderImpl implements Builder {
        private String synonyms;

        private String stopwords;

        private String stemmingDictionary;

        private String japaneseTokenizationDictionary;

        private String algorithmicStemming;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisOptions model) {
            synonyms(model.synonyms);
            stopwords(model.stopwords);
            stemmingDictionary(model.stemmingDictionary);
            japaneseTokenizationDictionary(model.japaneseTokenizationDictionary);
            algorithmicStemming(model.algorithmicStemming);
        }

        public final String getSynonyms() {
            return synonyms;
        }

        @Override
        public final Builder synonyms(String synonyms) {
            this.synonyms = synonyms;
            return this;
        }

        public final void setSynonyms(String synonyms) {
            this.synonyms = synonyms;
        }

        public final String getStopwords() {
            return stopwords;
        }

        @Override
        public final Builder stopwords(String stopwords) {
            this.stopwords = stopwords;
            return this;
        }

        public final void setStopwords(String stopwords) {
            this.stopwords = stopwords;
        }

        public final String getStemmingDictionary() {
            return stemmingDictionary;
        }

        @Override
        public final Builder stemmingDictionary(String stemmingDictionary) {
            this.stemmingDictionary = stemmingDictionary;
            return this;
        }

        public final void setStemmingDictionary(String stemmingDictionary) {
            this.stemmingDictionary = stemmingDictionary;
        }

        public final String getJapaneseTokenizationDictionary() {
            return japaneseTokenizationDictionary;
        }

        @Override
        public final Builder japaneseTokenizationDictionary(String japaneseTokenizationDictionary) {
            this.japaneseTokenizationDictionary = japaneseTokenizationDictionary;
            return this;
        }

        public final void setJapaneseTokenizationDictionary(String japaneseTokenizationDictionary) {
            this.japaneseTokenizationDictionary = japaneseTokenizationDictionary;
        }

        public final String getAlgorithmicStemming() {
            return algorithmicStemming;
        }

        @Override
        public final Builder algorithmicStemming(String algorithmicStemming) {
            this.algorithmicStemming = algorithmicStemming;
            return this;
        }

        @Override
        public final Builder algorithmicStemming(AlgorithmicStemming algorithmicStemming) {
            this.algorithmicStemming(algorithmicStemming == null ? null : algorithmicStemming.toString());
            return this;
        }

        public final void setAlgorithmicStemming(String algorithmicStemming) {
            this.algorithmicStemming = algorithmicStemming;
        }

        @Override
        public AnalysisOptions build() {
            return new AnalysisOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
