/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.cloudsearch.model.CloudSearchResponse;
import software.amazon.awssdk.services.cloudsearch.model.SuggesterStatus;
import software.amazon.awssdk.services.cloudsearch.model.SuggesterStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSuggestersResponse
extends CloudSearchResponse
implements ToCopyableBuilder<Builder, DescribeSuggestersResponse> {
    private static final SdkField<List<SuggesterStatus>> SUGGESTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(DescribeSuggestersResponse.getter(DescribeSuggestersResponse::suggesters)).setter(DescribeSuggestersResponse.setter(Builder::suggesters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Suggesters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SuggesterStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SUGGESTERS_FIELD));
    private final List<SuggesterStatus> suggesters;

    private DescribeSuggestersResponse(BuilderImpl builder) {
        super(builder);
        this.suggesters = builder.suggesters;
    }

    public boolean hasSuggesters() {
        return this.suggesters != null && !(this.suggesters instanceof SdkAutoConstructList);
    }

    public List<SuggesterStatus> suggesters() {
        return this.suggesters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.suggesters());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSuggestersResponse)) {
            return false;
        }
        DescribeSuggestersResponse other = (DescribeSuggestersResponse)((Object)obj);
        return Objects.equals(this.suggesters(), other.suggesters());
    }

    public String toString() {
        return ToString.builder((String)"DescribeSuggestersResponse").add("Suggesters", this.suggesters()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Suggesters": {
                return Optional.ofNullable(clazz.cast(this.suggesters()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeSuggestersResponse, T> g) {
        return obj -> g.apply((DescribeSuggestersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends CloudSearchResponse.BuilderImpl
    implements Builder {
        private List<SuggesterStatus> suggesters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSuggestersResponse model) {
            super(model);
            this.suggesters(model.suggesters);
        }

        public final Collection<SuggesterStatus.Builder> getSuggesters() {
            return this.suggesters != null ? (Collection)this.suggesters.stream().map(SuggesterStatus::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder suggesters(Collection<SuggesterStatus> suggesters) {
            this.suggesters = SuggesterStatusListCopier.copy(suggesters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggesters(SuggesterStatus ... suggesters) {
            this.suggesters(Arrays.asList(suggesters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder suggesters(Consumer<SuggesterStatus.Builder> ... suggesters) {
            this.suggesters(Stream.of(suggesters).map(c -> (SuggesterStatus)((SuggesterStatus.Builder)SuggesterStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setSuggesters(Collection<SuggesterStatus.BuilderImpl> suggesters) {
            this.suggesters = SuggesterStatusListCopier.copyFromBuilder(suggesters);
        }

        @Override
        public DescribeSuggestersResponse build() {
            return new DescribeSuggestersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends CloudSearchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeSuggestersResponse> {
        public Builder suggesters(Collection<SuggesterStatus> var1);

        public Builder suggesters(SuggesterStatus ... var1);

        public Builder suggesters(Consumer<SuggesterStatus.Builder> ... var1);
    }
}

