/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The result of a <code>ListDomainNames</code> request. Contains a list of the domains owned by an account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListDomainNamesResponse extends CloudSearchResponse implements
        ToCopyableBuilder<ListDomainNamesResponse.Builder, ListDomainNamesResponse> {
    private static final SdkField<Map<String, String>> DOMAIN_NAMES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(ListDomainNamesResponse::domainNames))
            .setter(setter(Builder::domainNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainNames").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAMES_FIELD));

    private final Map<String, String> domainNames;

    private ListDomainNamesResponse(BuilderImpl builder) {
        super(builder);
        this.domainNames = builder.domainNames;
    }

    /**
     * Returns true if the DomainNames property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public boolean hasDomainNames() {
        return domainNames != null && !(domainNames instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The names of the search domains owned by an account.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasDomainNames()} to see if a value was sent in this field.
     * </p>
     * 
     * @return The names of the search domains owned by an account.
     */
    public Map<String, String> domainNames() {
        return domainNames;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(domainNames());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDomainNamesResponse)) {
            return false;
        }
        ListDomainNamesResponse other = (ListDomainNamesResponse) obj;
        return Objects.equals(domainNames(), other.domainNames());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListDomainNamesResponse").add("DomainNames", domainNames()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DomainNames":
            return Optional.ofNullable(clazz.cast(domainNames()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListDomainNamesResponse, T> g) {
        return obj -> g.apply((ListDomainNamesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends CloudSearchResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListDomainNamesResponse> {
        /**
         * <p>
         * The names of the search domains owned by an account.
         * </p>
         * 
         * @param domainNames
         *        The names of the search domains owned by an account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainNames(Map<String, String> domainNames);
    }

    static final class BuilderImpl extends CloudSearchResponse.BuilderImpl implements Builder {
        private Map<String, String> domainNames = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListDomainNamesResponse model) {
            super(model);
            domainNames(model.domainNames);
        }

        public final Map<String, String> getDomainNames() {
            return domainNames;
        }

        @Override
        public final Builder domainNames(Map<String, String> domainNames) {
            this.domainNames = DomainNameMapCopier.copy(domainNames);
            return this;
        }

        public final void setDomainNames(Map<String, String> domainNames) {
            this.domainNames = DomainNameMapCopier.copy(domainNames);
        }

        @Override
        public ListDomainNamesResponse build() {
            return new ListDomainNamesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
