/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.cloudsearch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The value of an <code>Expression</code> and its current status.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExpressionStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ExpressionStatus.Builder, ExpressionStatus> {
    private static final SdkField<Expression> OPTIONS_FIELD = SdkField.<Expression> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExpressionStatus::options)).setter(setter(Builder::options)).constructor(Expression::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Options").build()).build();

    private static final SdkField<OptionStatus> STATUS_FIELD = SdkField.<OptionStatus> builder(MarshallingType.SDK_POJO)
            .getter(getter(ExpressionStatus::status)).setter(setter(Builder::status)).constructor(OptionStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OPTIONS_FIELD, STATUS_FIELD));

    private static final long serialVersionUID = 1L;

    private final Expression options;

    private final OptionStatus status;

    private ExpressionStatus(BuilderImpl builder) {
        this.options = builder.options;
        this.status = builder.status;
    }

    /**
     * <p>
     * The expression that is evaluated for sorting while processing a search request.
     * </p>
     * 
     * @return The expression that is evaluated for sorting while processing a search request.
     */
    public Expression options() {
        return options;
    }

    /**
     * Returns the value of the Status property for this object.
     * 
     * @return The value of the Status property for this object.
     */
    public OptionStatus status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(options());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExpressionStatus)) {
            return false;
        }
        ExpressionStatus other = (ExpressionStatus) obj;
        return Objects.equals(options(), other.options()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ExpressionStatus").add("Options", options()).add("Status", status()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Options":
            return Optional.ofNullable(clazz.cast(options()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ExpressionStatus, T> g) {
        return obj -> g.apply((ExpressionStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExpressionStatus> {
        /**
         * <p>
         * The expression that is evaluated for sorting while processing a search request.
         * </p>
         * 
         * @param options
         *        The expression that is evaluated for sorting while processing a search request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder options(Expression options);

        /**
         * <p>
         * The expression that is evaluated for sorting while processing a search request.
         * </p>
         * This is a convenience that creates an instance of the {@link Expression.Builder} avoiding the need to create
         * one manually via {@link Expression#builder()}.
         *
         * When the {@link Consumer} completes, {@link Expression.Builder#build()} is called immediately and its result
         * is passed to {@link #options(Expression)}.
         * 
         * @param options
         *        a consumer that will call methods on {@link Expression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #options(Expression)
         */
        default Builder options(Consumer<Expression.Builder> options) {
            return options(Expression.builder().applyMutation(options).build());
        }

        /**
         * Sets the value of the Status property for this object.
         *
         * @param status
         *        The new value for the Status property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(OptionStatus status);

        /**
         * Sets the value of the Status property for this object.
         *
         * This is a convenience that creates an instance of the {@link OptionStatus.Builder} avoiding the need to
         * create one manually via {@link OptionStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link OptionStatus.Builder#build()} is called immediately and its
         * result is passed to {@link #status(OptionStatus)}.
         * 
         * @param status
         *        a consumer that will call methods on {@link OptionStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #status(OptionStatus)
         */
        default Builder status(Consumer<OptionStatus.Builder> status) {
            return status(OptionStatus.builder().applyMutation(status).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private Expression options;

        private OptionStatus status;

        private BuilderImpl() {
        }

        private BuilderImpl(ExpressionStatus model) {
            options(model.options);
            status(model.status);
        }

        public final Expression.Builder getOptions() {
            return options != null ? options.toBuilder() : null;
        }

        @Override
        public final Builder options(Expression options) {
            this.options = options;
            return this;
        }

        public final void setOptions(Expression.BuilderImpl options) {
            this.options = options != null ? options.build() : null;
        }

        public final OptionStatus.Builder getStatus() {
            return status != null ? status.toBuilder() : null;
        }

        @Override
        public final Builder status(OptionStatus status) {
            this.status = status;
            return this;
        }

        public final void setStatus(OptionStatus.BuilderImpl status) {
            this.status = status != null ? status.build() : null;
        }

        @Override
        public ExpressionStatus build() {
            return new ExpressionStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
