/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.Bucket;

public class BucketUnmarshaller
implements Unmarshaller<Bucket, JsonUnmarshallerContext> {
    private static final BucketUnmarshaller INSTANCE = new BucketUnmarshaller();

    public Bucket unmarshall(JsonUnmarshallerContext context) throws Exception {
        Bucket.Builder bucketBuilder = Bucket.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("value", targetDepth)) {
                    context.nextToken();
                    bucketBuilder.value((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("count", targetDepth)) {
                    context.nextToken();
                    bucketBuilder.count((Long)context.getUnmarshaller(Long.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Bucket)bucketBuilder.build();
    }

    public static BucketUnmarshaller getInstance() {
        return INSTANCE;
    }
}

