/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import java.util.List;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.DescribeExpressionsRequest;

public class DescribeExpressionsRequestMarshaller
implements Marshaller<Request<DescribeExpressionsRequest>, DescribeExpressionsRequest> {
    public Request<DescribeExpressionsRequest> marshall(DescribeExpressionsRequest describeExpressionsRequest) {
        List<String> expressionNamesList;
        if (describeExpressionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((Object)describeExpressionsRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "DescribeExpressions");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeExpressionsRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)describeExpressionsRequest.domainName()));
        }
        if ((expressionNamesList = describeExpressionsRequest.expressionNames()) != null) {
            if (!expressionNamesList.isEmpty()) {
                int expressionNamesListIndex = 1;
                for (String expressionNamesListValue : expressionNamesList) {
                    if (expressionNamesListValue != null) {
                        request.addParameter("ExpressionNames.member." + expressionNamesListIndex, StringUtils.fromString((String)expressionNamesListValue));
                    }
                    ++expressionNamesListIndex;
                }
            } else {
                request.addParameter("ExpressionNames", "");
            }
        }
        if (describeExpressionsRequest.deployed() != null) {
            request.addParameter("Deployed", StringUtils.fromBoolean((Boolean)describeExpressionsRequest.deployed()));
        }
        return request;
    }
}

