/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.cloudsearch.model.SuggesterFuzzyMatching;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentSuggesterOptions
implements ToCopyableBuilder<Builder, DocumentSuggesterOptions> {
    private final String sourceField;
    private final String fuzzyMatching;
    private final String sortExpression;

    private DocumentSuggesterOptions(BuilderImpl builder) {
        this.sourceField = builder.sourceField;
        this.fuzzyMatching = builder.fuzzyMatching;
        this.sortExpression = builder.sortExpression;
    }

    public String sourceField() {
        return this.sourceField;
    }

    public SuggesterFuzzyMatching fuzzyMatching() {
        return SuggesterFuzzyMatching.fromValue(this.fuzzyMatching);
    }

    public String fuzzyMatchingString() {
        return this.fuzzyMatching;
    }

    public String sortExpression() {
        return this.sortExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(this.fuzzyMatchingString());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortExpression());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentSuggesterOptions)) {
            return false;
        }
        DocumentSuggesterOptions other = (DocumentSuggesterOptions)obj;
        return Objects.equals(this.sourceField(), other.sourceField()) && Objects.equals(this.fuzzyMatchingString(), other.fuzzyMatchingString()) && Objects.equals(this.sortExpression(), other.sortExpression());
    }

    public String toString() {
        return ToString.builder((String)"DocumentSuggesterOptions").add("SourceField", (Object)this.sourceField()).add("FuzzyMatching", (Object)this.fuzzyMatchingString()).add("SortExpression", (Object)this.sortExpression()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SourceField": {
                return Optional.of(clazz.cast(this.sourceField()));
            }
            case "FuzzyMatching": {
                return Optional.of(clazz.cast(this.fuzzyMatchingString()));
            }
            case "SortExpression": {
                return Optional.of(clazz.cast(this.sortExpression()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String sourceField;
        private String fuzzyMatching;
        private String sortExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentSuggesterOptions model) {
            this.sourceField(model.sourceField);
            this.fuzzyMatching(model.fuzzyMatching);
            this.sortExpression(model.sortExpression);
        }

        public final String getSourceField() {
            return this.sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public final String getFuzzyMatching() {
            return this.fuzzyMatching;
        }

        @Override
        public final Builder fuzzyMatching(String fuzzyMatching) {
            this.fuzzyMatching = fuzzyMatching;
            return this;
        }

        @Override
        public final Builder fuzzyMatching(SuggesterFuzzyMatching fuzzyMatching) {
            this.fuzzyMatching(fuzzyMatching.toString());
            return this;
        }

        public final void setFuzzyMatching(String fuzzyMatching) {
            this.fuzzyMatching = fuzzyMatching;
        }

        public final String getSortExpression() {
            return this.sortExpression;
        }

        @Override
        public final Builder sortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
            return this;
        }

        public final void setSortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
        }

        public DocumentSuggesterOptions build() {
            return new DocumentSuggesterOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentSuggesterOptions> {
        public Builder sourceField(String var1);

        public Builder fuzzyMatching(String var1);

        public Builder fuzzyMatching(SuggesterFuzzyMatching var1);

        public Builder sortExpression(String var1);
    }
}

