/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisOptions;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeLanguage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AnalysisScheme
implements ToCopyableBuilder<Builder, AnalysisScheme> {
    private final String analysisSchemeName;
    private final String analysisSchemeLanguage;
    private final AnalysisOptions analysisOptions;

    private AnalysisScheme(BuilderImpl builder) {
        this.analysisSchemeName = builder.analysisSchemeName;
        this.analysisSchemeLanguage = builder.analysisSchemeLanguage;
        this.analysisOptions = builder.analysisOptions;
    }

    public String analysisSchemeName() {
        return this.analysisSchemeName;
    }

    public AnalysisSchemeLanguage analysisSchemeLanguage() {
        return AnalysisSchemeLanguage.fromValue(this.analysisSchemeLanguage);
    }

    public String analysisSchemeLanguageString() {
        return this.analysisSchemeLanguage;
    }

    public AnalysisOptions analysisOptions() {
        return this.analysisOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSchemeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisSchemeLanguageString());
        hashCode = 31 * hashCode + Objects.hashCode(this.analysisOptions());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisScheme)) {
            return false;
        }
        AnalysisScheme other = (AnalysisScheme)obj;
        return Objects.equals(this.analysisSchemeName(), other.analysisSchemeName()) && Objects.equals(this.analysisSchemeLanguageString(), other.analysisSchemeLanguageString()) && Objects.equals(this.analysisOptions(), other.analysisOptions());
    }

    public String toString() {
        return ToString.builder((String)"AnalysisScheme").add("AnalysisSchemeName", (Object)this.analysisSchemeName()).add("AnalysisSchemeLanguage", (Object)this.analysisSchemeLanguageString()).add("AnalysisOptions", (Object)this.analysisOptions()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisSchemeName": {
                return Optional.of(clazz.cast(this.analysisSchemeName()));
            }
            case "AnalysisSchemeLanguage": {
                return Optional.of(clazz.cast(this.analysisSchemeLanguageString()));
            }
            case "AnalysisOptions": {
                return Optional.of(clazz.cast(this.analysisOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String analysisSchemeName;
        private String analysisSchemeLanguage;
        private AnalysisOptions analysisOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisScheme model) {
            this.analysisSchemeName(model.analysisSchemeName);
            this.analysisSchemeLanguage(model.analysisSchemeLanguage);
            this.analysisOptions(model.analysisOptions);
        }

        public final String getAnalysisSchemeName() {
            return this.analysisSchemeName;
        }

        @Override
        public final Builder analysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
            return this;
        }

        public final void setAnalysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
        }

        public final String getAnalysisSchemeLanguage() {
            return this.analysisSchemeLanguage;
        }

        @Override
        public final Builder analysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
            return this;
        }

        @Override
        public final Builder analysisSchemeLanguage(AnalysisSchemeLanguage analysisSchemeLanguage) {
            this.analysisSchemeLanguage(analysisSchemeLanguage.toString());
            return this;
        }

        public final void setAnalysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
        }

        public final AnalysisOptions.Builder getAnalysisOptions() {
            return this.analysisOptions != null ? this.analysisOptions.toBuilder() : null;
        }

        @Override
        public final Builder analysisOptions(AnalysisOptions analysisOptions) {
            this.analysisOptions = analysisOptions;
            return this;
        }

        public final void setAnalysisOptions(AnalysisOptions.BuilderImpl analysisOptions) {
            this.analysisOptions = analysisOptions != null ? analysisOptions.build() : null;
        }

        public AnalysisScheme build() {
            return new AnalysisScheme(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AnalysisScheme> {
        public Builder analysisSchemeName(String var1);

        public Builder analysisSchemeLanguage(String var1);

        public Builder analysisSchemeLanguage(AnalysisSchemeLanguage var1);

        public Builder analysisOptions(AnalysisOptions var1);

        default public Builder analysisOptions(Consumer<AnalysisOptions.Builder> analysisOptions) {
            return this.analysisOptions((AnalysisOptions)((AnalysisOptions.Builder)AnalysisOptions.builder().apply(analysisOptions)).build());
        }
    }
}

