/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class IntArrayOptions
implements ToCopyableBuilder<Builder, IntArrayOptions> {
    private final Long defaultValue;
    private final String sourceFields;
    private final Boolean facetEnabled;
    private final Boolean searchEnabled;
    private final Boolean returnEnabled;

    private IntArrayOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceFields = builder.sourceFields;
        this.facetEnabled = builder.facetEnabled;
        this.searchEnabled = builder.searchEnabled;
        this.returnEnabled = builder.returnEnabled;
    }

    public Long defaultValue() {
        return this.defaultValue;
    }

    public String sourceFields() {
        return this.sourceFields;
    }

    public Boolean facetEnabled() {
        return this.facetEnabled;
    }

    public Boolean searchEnabled() {
        return this.searchEnabled;
    }

    public Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceFields());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IntArrayOptions)) {
            return false;
        }
        IntArrayOptions other = (IntArrayOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.sourceFields(), other.sourceFields()) && Objects.equals(this.facetEnabled(), other.facetEnabled()) && Objects.equals(this.searchEnabled(), other.searchEnabled()) && Objects.equals(this.returnEnabled(), other.returnEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        if (this.sourceFields() != null) {
            sb.append("SourceFields: ").append(this.sourceFields()).append(",");
        }
        if (this.facetEnabled() != null) {
            sb.append("FacetEnabled: ").append(this.facetEnabled()).append(",");
        }
        if (this.searchEnabled() != null) {
            sb.append("SearchEnabled: ").append(this.searchEnabled()).append(",");
        }
        if (this.returnEnabled() != null) {
            sb.append("ReturnEnabled: ").append(this.returnEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.of(clazz.cast(this.defaultValue()));
            }
            case "SourceFields": {
                return Optional.of(clazz.cast(this.sourceFields()));
            }
            case "FacetEnabled": {
                return Optional.of(clazz.cast(this.facetEnabled()));
            }
            case "SearchEnabled": {
                return Optional.of(clazz.cast(this.searchEnabled()));
            }
            case "ReturnEnabled": {
                return Optional.of(clazz.cast(this.returnEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Long defaultValue;
        private String sourceFields;
        private Boolean facetEnabled;
        private Boolean searchEnabled;
        private Boolean returnEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(IntArrayOptions model) {
            this.defaultValue(model.defaultValue);
            this.sourceFields(model.sourceFields);
            this.facetEnabled(model.facetEnabled);
            this.searchEnabled(model.searchEnabled);
            this.returnEnabled(model.returnEnabled);
        }

        public final Long getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(Long defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(Long defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceFields() {
            return this.sourceFields;
        }

        @Override
        public final Builder sourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
            return this;
        }

        public final void setSourceFields(String sourceFields) {
            this.sourceFields = sourceFields;
        }

        public final Boolean getFacetEnabled() {
            return this.facetEnabled;
        }

        @Override
        public final Builder facetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
            return this;
        }

        public final void setFacetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
        }

        public final Boolean getSearchEnabled() {
            return this.searchEnabled;
        }

        @Override
        public final Builder searchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
            return this;
        }

        public final void setSearchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        public IntArrayOptions build() {
            return new IntArrayOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, IntArrayOptions> {
        public Builder defaultValue(Long var1);

        public Builder sourceFields(String var1);

        public Builder facetEnabled(Boolean var1);

        public Builder searchEnabled(Boolean var1);

        public Builder returnEnabled(Boolean var1);
    }
}

