/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DateOptions
implements ToCopyableBuilder<Builder, DateOptions> {
    private final String defaultValue;
    private final String sourceField;
    private final Boolean facetEnabled;
    private final Boolean searchEnabled;
    private final Boolean returnEnabled;
    private final Boolean sortEnabled;

    private DateOptions(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.sourceField = builder.sourceField;
        this.facetEnabled = builder.facetEnabled;
        this.searchEnabled = builder.searchEnabled;
        this.returnEnabled = builder.returnEnabled;
        this.sortEnabled = builder.sortEnabled;
    }

    public String defaultValue() {
        return this.defaultValue;
    }

    public String sourceField() {
        return this.sourceField;
    }

    public Boolean facetEnabled() {
        return this.facetEnabled;
    }

    public Boolean searchEnabled() {
        return this.searchEnabled;
    }

    public Boolean returnEnabled() {
        return this.returnEnabled;
    }

    public Boolean sortEnabled() {
        return this.sortEnabled;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceField());
        hashCode = 31 * hashCode + Objects.hashCode(this.facetEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.returnEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.sortEnabled());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DateOptions)) {
            return false;
        }
        DateOptions other = (DateOptions)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.sourceField(), other.sourceField()) && Objects.equals(this.facetEnabled(), other.facetEnabled()) && Objects.equals(this.searchEnabled(), other.searchEnabled()) && Objects.equals(this.returnEnabled(), other.returnEnabled()) && Objects.equals(this.sortEnabled(), other.sortEnabled());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.defaultValue() != null) {
            sb.append("DefaultValue: ").append(this.defaultValue()).append(",");
        }
        if (this.sourceField() != null) {
            sb.append("SourceField: ").append(this.sourceField()).append(",");
        }
        if (this.facetEnabled() != null) {
            sb.append("FacetEnabled: ").append(this.facetEnabled()).append(",");
        }
        if (this.searchEnabled() != null) {
            sb.append("SearchEnabled: ").append(this.searchEnabled()).append(",");
        }
        if (this.returnEnabled() != null) {
            sb.append("ReturnEnabled: ").append(this.returnEnabled()).append(",");
        }
        if (this.sortEnabled() != null) {
            sb.append("SortEnabled: ").append(this.sortEnabled()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "DefaultValue": {
                return Optional.of(clazz.cast(this.defaultValue()));
            }
            case "SourceField": {
                return Optional.of(clazz.cast(this.sourceField()));
            }
            case "FacetEnabled": {
                return Optional.of(clazz.cast(this.facetEnabled()));
            }
            case "SearchEnabled": {
                return Optional.of(clazz.cast(this.searchEnabled()));
            }
            case "ReturnEnabled": {
                return Optional.of(clazz.cast(this.returnEnabled()));
            }
            case "SortEnabled": {
                return Optional.of(clazz.cast(this.sortEnabled()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String sourceField;
        private Boolean facetEnabled;
        private Boolean searchEnabled;
        private Boolean returnEnabled;
        private Boolean sortEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(DateOptions model) {
            this.defaultValue(model.defaultValue);
            this.sourceField(model.sourceField);
            this.facetEnabled(model.facetEnabled);
            this.searchEnabled(model.searchEnabled);
            this.returnEnabled(model.returnEnabled);
            this.sortEnabled(model.sortEnabled);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        public final String getSourceField() {
            return this.sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public final Boolean getFacetEnabled() {
            return this.facetEnabled;
        }

        @Override
        public final Builder facetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
            return this;
        }

        public final void setFacetEnabled(Boolean facetEnabled) {
            this.facetEnabled = facetEnabled;
        }

        public final Boolean getSearchEnabled() {
            return this.searchEnabled;
        }

        @Override
        public final Builder searchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
            return this;
        }

        public final void setSearchEnabled(Boolean searchEnabled) {
            this.searchEnabled = searchEnabled;
        }

        public final Boolean getReturnEnabled() {
            return this.returnEnabled;
        }

        @Override
        public final Builder returnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
            return this;
        }

        public final void setReturnEnabled(Boolean returnEnabled) {
            this.returnEnabled = returnEnabled;
        }

        public final Boolean getSortEnabled() {
            return this.sortEnabled;
        }

        @Override
        public final Builder sortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
            return this;
        }

        public final void setSortEnabled(Boolean sortEnabled) {
            this.sortEnabled = sortEnabled;
        }

        public DateOptions build() {
            return new DateOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DateOptions> {
        public Builder defaultValue(String var1);

        public Builder sourceField(String var1);

        public Builder facetEnabled(Boolean var1);

        public Builder searchEnabled(Boolean var1);

        public Builder returnEnabled(Boolean var1);

        public Builder sortEnabled(Boolean var1);
    }
}

