/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearchdomain.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.cloudsearchdomain.model.SearchRequest;

@SdkInternalApi
public class SearchRequestModelMarshaller {
    private static final MarshallingInfo<String> CURSOR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("cursor").build();
    private static final MarshallingInfo<String> EXPR_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("expr").build();
    private static final MarshallingInfo<String> FACET_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("facet").build();
    private static final MarshallingInfo<String> FILTERQUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("fq").build();
    private static final MarshallingInfo<String> HIGHLIGHT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("highlight").build();
    private static final MarshallingInfo<Boolean> PARTIAL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.BOOLEAN).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("partial").build();
    private static final MarshallingInfo<String> QUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("q").build();
    private static final MarshallingInfo<String> QUERYOPTIONS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("q.options").build();
    private static final MarshallingInfo<String> QUERYPARSER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("q.parser").build();
    private static final MarshallingInfo<Long> SIZE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("size").build();
    private static final MarshallingInfo<String> SORT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("sort").build();
    private static final MarshallingInfo<Long> START_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LONG).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("start").build();
    private static final MarshallingInfo<String> STATS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("stats").build();
    private static final MarshallingInfo<String> RETURNVALUES_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.QUERY_PARAM).marshallLocationName("return").build();
    private static final SearchRequestModelMarshaller INSTANCE = new SearchRequestModelMarshaller();

    public static SearchRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(SearchRequest searchRequest, ProtocolMarshaller protocolMarshaller) {
        if (searchRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)searchRequest.cursor(), CURSOR_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.expr(), EXPR_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.facet(), FACET_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.filterQuery(), FILTERQUERY_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.highlight(), HIGHLIGHT_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.partial(), PARTIAL_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.query(), QUERY_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.queryOptions(), QUERYOPTIONS_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.queryParserString(), QUERYPARSER_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.size(), SIZE_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.sort(), SORT_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.start(), START_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.stats(), STATS_BINDING);
            protocolMarshaller.marshall((Object)searchRequest.returnValues(), RETURNVALUES_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

