/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import software.amazon.awssdk.core.AmazonWebServiceRequest;
import software.amazon.awssdk.core.DefaultRequest;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.util.StringUtils;
import software.amazon.awssdk.services.cloudsearch.model.ScalingParameters;
import software.amazon.awssdk.services.cloudsearch.model.UpdateScalingParametersRequest;

public class UpdateScalingParametersRequestMarshaller
implements Marshaller<Request<UpdateScalingParametersRequest>, UpdateScalingParametersRequest> {
    public Request<UpdateScalingParametersRequest> marshall(UpdateScalingParametersRequest updateScalingParametersRequest) {
        ScalingParameters scalingParameters;
        if (updateScalingParametersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateScalingParametersRequest, "AmazonCloudSearchv2");
        request.addParameter("Action", "UpdateScalingParameters");
        request.addParameter("Version", "2013-01-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (updateScalingParametersRequest.domainName() != null) {
            request.addParameter("DomainName", StringUtils.fromString((String)updateScalingParametersRequest.domainName()));
        }
        if ((scalingParameters = updateScalingParametersRequest.scalingParameters()) != null) {
            if (scalingParameters.desiredInstanceTypeString() != null) {
                request.addParameter("ScalingParameters.DesiredInstanceType", StringUtils.fromString((String)scalingParameters.desiredInstanceTypeString()));
            }
            if (scalingParameters.desiredReplicationCount() != null) {
                request.addParameter("ScalingParameters.DesiredReplicationCount", StringUtils.fromInteger((Integer)scalingParameters.desiredReplicationCount()));
            }
            if (scalingParameters.desiredPartitionCount() != null) {
                request.addParameter("ScalingParameters.DesiredPartitionCount", StringUtils.fromInteger((Integer)scalingParameters.desiredPartitionCount()));
            }
        }
        return request;
    }
}

