/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.core.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.core.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.IndexField;
import software.amazon.awssdk.services.cloudsearch.transform.DateArrayOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DateOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DoubleArrayOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.DoubleOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.IntArrayOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.IntOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.LatLonOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.LiteralArrayOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.LiteralOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.TextArrayOptionsUnmarshaller;
import software.amazon.awssdk.services.cloudsearch.transform.TextOptionsUnmarshaller;

public class IndexFieldUnmarshaller
implements Unmarshaller<IndexField, StaxUnmarshallerContext> {
    private static final IndexFieldUnmarshaller INSTANCE = new IndexFieldUnmarshaller();

    public IndexField unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        IndexField.Builder indexField = IndexField.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("IndexFieldName", targetDepth)) {
                    indexField.indexFieldName(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IndexFieldType", targetDepth)) {
                    indexField.indexFieldType(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IntOptions", targetDepth)) {
                    indexField.intOptions(IntOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DoubleOptions", targetDepth)) {
                    indexField.doubleOptions(DoubleOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LiteralOptions", targetDepth)) {
                    indexField.literalOptions(LiteralOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TextOptions", targetDepth)) {
                    indexField.textOptions(TextOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DateOptions", targetDepth)) {
                    indexField.dateOptions(DateOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LatLonOptions", targetDepth)) {
                    indexField.latLonOptions(LatLonOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("IntArrayOptions", targetDepth)) {
                    indexField.intArrayOptions(IntArrayOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DoubleArrayOptions", targetDepth)) {
                    indexField.doubleArrayOptions(DoubleArrayOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("LiteralArrayOptions", targetDepth)) {
                    indexField.literalArrayOptions(LiteralArrayOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("TextArrayOptions", targetDepth)) {
                    indexField.textArrayOptions(TextArrayOptionsUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("DateArrayOptions", targetDepth)) continue;
                indexField.dateArrayOptions(DateArrayOptionsUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (IndexField)indexField.build();
    }

    public static IndexFieldUnmarshaller getInstance() {
        return INSTANCE;
    }
}

