/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.time.Instant;
import java.util.Optional;
import software.amazon.awssdk.services.cloudsearch.model.OptionState;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class OptionStatus
implements ToCopyableBuilder<Builder, OptionStatus> {
    private final Instant creationDate;
    private final Instant updateDate;
    private final Integer updateVersion;
    private final String state;
    private final Boolean pendingDeletion;

    private OptionStatus(BuilderImpl builder) {
        this.creationDate = builder.creationDate;
        this.updateDate = builder.updateDate;
        this.updateVersion = builder.updateVersion;
        this.state = builder.state;
        this.pendingDeletion = builder.pendingDeletion;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Instant updateDate() {
        return this.updateDate;
    }

    public Integer updateVersion() {
        return this.updateVersion;
    }

    public OptionState state() {
        return OptionState.fromValue(this.state);
    }

    public String stateString() {
        return this.state;
    }

    public Boolean pendingDeletion() {
        return this.pendingDeletion;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.creationDate() == null ? 0 : this.creationDate().hashCode());
        hashCode = 31 * hashCode + (this.updateDate() == null ? 0 : this.updateDate().hashCode());
        hashCode = 31 * hashCode + (this.updateVersion() == null ? 0 : this.updateVersion().hashCode());
        hashCode = 31 * hashCode + (this.stateString() == null ? 0 : this.stateString().hashCode());
        hashCode = 31 * hashCode + (this.pendingDeletion() == null ? 0 : this.pendingDeletion().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OptionStatus)) {
            return false;
        }
        OptionStatus other = (OptionStatus)obj;
        if (other.creationDate() == null ^ this.creationDate() == null) {
            return false;
        }
        if (other.creationDate() != null && !other.creationDate().equals(this.creationDate())) {
            return false;
        }
        if (other.updateDate() == null ^ this.updateDate() == null) {
            return false;
        }
        if (other.updateDate() != null && !other.updateDate().equals(this.updateDate())) {
            return false;
        }
        if (other.updateVersion() == null ^ this.updateVersion() == null) {
            return false;
        }
        if (other.updateVersion() != null && !other.updateVersion().equals(this.updateVersion())) {
            return false;
        }
        if (other.stateString() == null ^ this.stateString() == null) {
            return false;
        }
        if (other.stateString() != null && !other.stateString().equals(this.stateString())) {
            return false;
        }
        if (other.pendingDeletion() == null ^ this.pendingDeletion() == null) {
            return false;
        }
        return other.pendingDeletion() == null || other.pendingDeletion().equals(this.pendingDeletion());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.creationDate() != null) {
            sb.append("CreationDate: ").append(this.creationDate()).append(",");
        }
        if (this.updateDate() != null) {
            sb.append("UpdateDate: ").append(this.updateDate()).append(",");
        }
        if (this.updateVersion() != null) {
            sb.append("UpdateVersion: ").append(this.updateVersion()).append(",");
        }
        if (this.stateString() != null) {
            sb.append("State: ").append(this.stateString()).append(",");
        }
        if (this.pendingDeletion() != null) {
            sb.append("PendingDeletion: ").append(this.pendingDeletion()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CreationDate": {
                return Optional.of(clazz.cast(this.creationDate()));
            }
            case "UpdateDate": {
                return Optional.of(clazz.cast(this.updateDate()));
            }
            case "UpdateVersion": {
                return Optional.of(clazz.cast(this.updateVersion()));
            }
            case "State": {
                return Optional.of(clazz.cast(this.stateString()));
            }
            case "PendingDeletion": {
                return Optional.of(clazz.cast(this.pendingDeletion()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private Instant creationDate;
        private Instant updateDate;
        private Integer updateVersion;
        private String state;
        private Boolean pendingDeletion;

        private BuilderImpl() {
        }

        private BuilderImpl(OptionStatus model) {
            this.creationDate(model.creationDate);
            this.updateDate(model.updateDate);
            this.updateVersion(model.updateVersion);
            this.state(model.state);
            this.pendingDeletion(model.pendingDeletion);
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getUpdateDate() {
            return this.updateDate;
        }

        @Override
        public final Builder updateDate(Instant updateDate) {
            this.updateDate = updateDate;
            return this;
        }

        public final void setUpdateDate(Instant updateDate) {
            this.updateDate = updateDate;
        }

        public final Integer getUpdateVersion() {
            return this.updateVersion;
        }

        @Override
        public final Builder updateVersion(Integer updateVersion) {
            this.updateVersion = updateVersion;
            return this;
        }

        public final void setUpdateVersion(Integer updateVersion) {
            this.updateVersion = updateVersion;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(OptionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final Boolean getPendingDeletion() {
            return this.pendingDeletion;
        }

        @Override
        public final Builder pendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
            return this;
        }

        public final void setPendingDeletion(Boolean pendingDeletion) {
            this.pendingDeletion = pendingDeletion;
        }

        public OptionStatus build() {
            return new OptionStatus(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, OptionStatus> {
        public Builder creationDate(Instant var1);

        public Builder updateDate(Instant var1);

        public Builder updateVersion(Integer var1);

        public Builder state(String var1);

        public Builder state(OptionState var1);

        public Builder pendingDeletion(Boolean var1);
    }
}

