/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import java.util.Optional;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisOptions;
import software.amazon.awssdk.services.cloudsearch.model.AnalysisSchemeLanguage;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class AnalysisScheme
implements ToCopyableBuilder<Builder, AnalysisScheme> {
    private final String analysisSchemeName;
    private final String analysisSchemeLanguage;
    private final AnalysisOptions analysisOptions;

    private AnalysisScheme(BuilderImpl builder) {
        this.analysisSchemeName = builder.analysisSchemeName;
        this.analysisSchemeLanguage = builder.analysisSchemeLanguage;
        this.analysisOptions = builder.analysisOptions;
    }

    public String analysisSchemeName() {
        return this.analysisSchemeName;
    }

    public AnalysisSchemeLanguage analysisSchemeLanguage() {
        return AnalysisSchemeLanguage.fromValue(this.analysisSchemeLanguage);
    }

    public String analysisSchemeLanguageString() {
        return this.analysisSchemeLanguage;
    }

    public AnalysisOptions analysisOptions() {
        return this.analysisOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.analysisSchemeName() == null ? 0 : this.analysisSchemeName().hashCode());
        hashCode = 31 * hashCode + (this.analysisSchemeLanguageString() == null ? 0 : this.analysisSchemeLanguageString().hashCode());
        hashCode = 31 * hashCode + (this.analysisOptions() == null ? 0 : this.analysisOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisScheme)) {
            return false;
        }
        AnalysisScheme other = (AnalysisScheme)obj;
        if (other.analysisSchemeName() == null ^ this.analysisSchemeName() == null) {
            return false;
        }
        if (other.analysisSchemeName() != null && !other.analysisSchemeName().equals(this.analysisSchemeName())) {
            return false;
        }
        if (other.analysisSchemeLanguageString() == null ^ this.analysisSchemeLanguageString() == null) {
            return false;
        }
        if (other.analysisSchemeLanguageString() != null && !other.analysisSchemeLanguageString().equals(this.analysisSchemeLanguageString())) {
            return false;
        }
        if (other.analysisOptions() == null ^ this.analysisOptions() == null) {
            return false;
        }
        return other.analysisOptions() == null || other.analysisOptions().equals(this.analysisOptions());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        if (this.analysisSchemeName() != null) {
            sb.append("AnalysisSchemeName: ").append(this.analysisSchemeName()).append(",");
        }
        if (this.analysisSchemeLanguageString() != null) {
            sb.append("AnalysisSchemeLanguage: ").append(this.analysisSchemeLanguageString()).append(",");
        }
        if (this.analysisOptions() != null) {
            sb.append("AnalysisOptions: ").append(this.analysisOptions()).append(",");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AnalysisSchemeName": {
                return Optional.of(clazz.cast(this.analysisSchemeName()));
            }
            case "AnalysisSchemeLanguage": {
                return Optional.of(clazz.cast(this.analysisSchemeLanguageString()));
            }
            case "AnalysisOptions": {
                return Optional.of(clazz.cast(this.analysisOptions()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    implements Builder {
        private String analysisSchemeName;
        private String analysisSchemeLanguage;
        private AnalysisOptions analysisOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(AnalysisScheme model) {
            this.analysisSchemeName(model.analysisSchemeName);
            this.analysisSchemeLanguage(model.analysisSchemeLanguage);
            this.analysisOptions(model.analysisOptions);
        }

        public final String getAnalysisSchemeName() {
            return this.analysisSchemeName;
        }

        @Override
        public final Builder analysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
            return this;
        }

        public final void setAnalysisSchemeName(String analysisSchemeName) {
            this.analysisSchemeName = analysisSchemeName;
        }

        public final String getAnalysisSchemeLanguage() {
            return this.analysisSchemeLanguage;
        }

        @Override
        public final Builder analysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
            return this;
        }

        @Override
        public final Builder analysisSchemeLanguage(AnalysisSchemeLanguage analysisSchemeLanguage) {
            this.analysisSchemeLanguage(analysisSchemeLanguage.toString());
            return this;
        }

        public final void setAnalysisSchemeLanguage(String analysisSchemeLanguage) {
            this.analysisSchemeLanguage = analysisSchemeLanguage;
        }

        public final AnalysisOptions.Builder getAnalysisOptions() {
            return this.analysisOptions != null ? this.analysisOptions.toBuilder() : null;
        }

        @Override
        public final Builder analysisOptions(AnalysisOptions analysisOptions) {
            this.analysisOptions = analysisOptions;
            return this;
        }

        public final void setAnalysisOptions(AnalysisOptions.BuilderImpl analysisOptions) {
            this.analysisOptions = analysisOptions != null ? analysisOptions.build() : null;
        }

        public AnalysisScheme build() {
            return new AnalysisScheme(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, AnalysisScheme> {
        public Builder analysisSchemeName(String var1);

        public Builder analysisSchemeLanguage(String var1);

        public Builder analysisSchemeLanguage(AnalysisSchemeLanguage var1);

        public Builder analysisOptions(AnalysisOptions var1);
    }
}

