/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.model;

import software.amazon.awssdk.services.cloudsearch.model.SuggesterFuzzyMatching;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DocumentSuggesterOptions
implements ToCopyableBuilder<Builder, DocumentSuggesterOptions> {
    private final String sourceField;
    private final String fuzzyMatching;
    private final String sortExpression;

    private DocumentSuggesterOptions(BuilderImpl builder) {
        this.sourceField = builder.sourceField;
        this.fuzzyMatching = builder.fuzzyMatching;
        this.sortExpression = builder.sortExpression;
    }

    public String sourceField() {
        return this.sourceField;
    }

    public String fuzzyMatching() {
        return this.fuzzyMatching;
    }

    public String sortExpression() {
        return this.sortExpression;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.sourceField() == null ? 0 : this.sourceField().hashCode());
        hashCode = 31 * hashCode + (this.fuzzyMatching() == null ? 0 : this.fuzzyMatching().hashCode());
        hashCode = 31 * hashCode + (this.sortExpression() == null ? 0 : this.sortExpression().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DocumentSuggesterOptions)) {
            return false;
        }
        DocumentSuggesterOptions other = (DocumentSuggesterOptions)obj;
        if (other.sourceField() == null ^ this.sourceField() == null) {
            return false;
        }
        if (other.sourceField() != null && !other.sourceField().equals(this.sourceField())) {
            return false;
        }
        if (other.fuzzyMatching() == null ^ this.fuzzyMatching() == null) {
            return false;
        }
        if (other.fuzzyMatching() != null && !other.fuzzyMatching().equals(this.fuzzyMatching())) {
            return false;
        }
        if (other.sortExpression() == null ^ this.sortExpression() == null) {
            return false;
        }
        return other.sortExpression() == null || other.sortExpression().equals(this.sortExpression());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.sourceField() != null) {
            sb.append("SourceField: ").append(this.sourceField()).append(",");
        }
        if (this.fuzzyMatching() != null) {
            sb.append("FuzzyMatching: ").append(this.fuzzyMatching()).append(",");
        }
        if (this.sortExpression() != null) {
            sb.append("SortExpression: ").append(this.sortExpression()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private String sourceField;
        private String fuzzyMatching;
        private String sortExpression;

        private BuilderImpl() {
        }

        private BuilderImpl(DocumentSuggesterOptions model) {
            this.setSourceField(model.sourceField);
            this.setFuzzyMatching(model.fuzzyMatching);
            this.setSortExpression(model.sortExpression);
        }

        public final String getSourceField() {
            return this.sourceField;
        }

        @Override
        public final Builder sourceField(String sourceField) {
            this.sourceField = sourceField;
            return this;
        }

        public final void setSourceField(String sourceField) {
            this.sourceField = sourceField;
        }

        public final String getFuzzyMatching() {
            return this.fuzzyMatching;
        }

        @Override
        public final Builder fuzzyMatching(String fuzzyMatching) {
            this.fuzzyMatching = fuzzyMatching;
            return this;
        }

        @Override
        public final Builder fuzzyMatching(SuggesterFuzzyMatching fuzzyMatching) {
            this.fuzzyMatching(fuzzyMatching.toString());
            return this;
        }

        public final void setFuzzyMatching(String fuzzyMatching) {
            this.fuzzyMatching = fuzzyMatching;
        }

        public final String getSortExpression() {
            return this.sortExpression;
        }

        @Override
        public final Builder sortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
            return this;
        }

        public final void setSortExpression(String sortExpression) {
            this.sortExpression = sortExpression;
        }

        public DocumentSuggesterOptions build() {
            return new DocumentSuggesterOptions(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DocumentSuggesterOptions> {
        public Builder sourceField(String var1);

        public Builder fuzzyMatching(String var1);

        public Builder fuzzyMatching(SuggesterFuzzyMatching var1);

        public Builder sortExpression(String var1);
    }
}

