/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cloudsearch.transform;

import javax.xml.stream.events.XMLEvent;
import software.amazon.awssdk.runtime.transform.SimpleTypeStaxUnmarshallers;
import software.amazon.awssdk.runtime.transform.StaxUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.cloudsearch.model.IntArrayOptions;

public class IntArrayOptionsUnmarshaller
implements Unmarshaller<IntArrayOptions, StaxUnmarshallerContext> {
    private static final IntArrayOptionsUnmarshaller INSTANCE = new IntArrayOptionsUnmarshaller();

    public IntArrayOptions unmarshall(StaxUnmarshallerContext context) throws Exception {
        XMLEvent xmlEvent;
        IntArrayOptions.Builder intArrayOptions = IntArrayOptions.builder();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (!(xmlEvent = context.nextEvent()).isEndDocument()) {
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("DefaultValue", targetDepth)) {
                    intArrayOptions.defaultValue(SimpleTypeStaxUnmarshallers.LongUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SourceFields", targetDepth)) {
                    intArrayOptions.sourceFields(SimpleTypeStaxUnmarshallers.StringUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("FacetEnabled", targetDepth)) {
                    intArrayOptions.facetEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("SearchEnabled", targetDepth)) {
                    intArrayOptions.searchEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("ReturnEnabled", targetDepth)) continue;
                intArrayOptions.returnEnabled(SimpleTypeStaxUnmarshallers.BooleanUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (!xmlEvent.isEndElement() || context.getCurrentDepth() >= originalDepth) continue;
            break;
        }
        return (IntArrayOptions)intArrayOptions.build();
    }

    public static IntArrayOptionsUnmarshaller getInstance() {
        return INSTANCE;
    }
}

